/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReconnectWithSameClientIDTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(ReconnectWithSameClientIDTest.class);
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;

    public void testReconnectMultipleTimesWithSameClientID() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        for (int i = 1; i < 11; ++i) {
            Connection connection2 = this.connectionFactory.createConnection();
            try {
                this.useConnection(connection2);
                ReconnectWithSameClientIDTest.fail((String)("Should have thrown InvalidClientIDException on attempt" + i));
                continue;
            }
            catch (InvalidClientIDException e) {
                connection2.close();
                LOG.info((Object)("Caught expected: " + (Object)((Object)e)));
            }
        }
        this.connection.close();
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    protected void useConnection(Connection connection) throws JMSException {
        connection.setClientID("foo");
        connection.start();
    }
}

