/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.CommandMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public class AuthenticationMessage
extends CommandMessage {
    public static final String KEY_PASSWORD = "password";
    private String password;

    public AuthenticationMessage() {
    }

    public AuthenticationMessage(AuthenticationOperation operation) {
        super(operation.toString());
    }

    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.password = from.getString(KEY_PASSWORD);
    }

    public void marshal(MapMessage to) throws JMSException {
        super.marshal(to);
        to.setString(KEY_PASSWORD, this.password);
    }

    public boolean isRequestForAuthentication() {
        return AuthenticationOperation.REQUEST.toString().equals(this.getCommand()) || AuthenticationOperation.LOGIN_FAILED.toString().equals(this.getCommand());
    }

    public boolean isLogin() {
        return AuthenticationOperation.LOGIN.toString().equals(this.getCommand());
    }

    public boolean isLogout() {
        return AuthenticationOperation.LOGOUT.toString().equals(this.getCommand());
    }

    public boolean isLoginAck() {
        return AuthenticationOperation.LOGIN_SUCCEEDED.toString().equals(this.getCommand());
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationOperation {
        LOGIN,
        LOGOUT,
        REQUEST,
        LOGIN_FAILED,
        LOGIN_SUCCEEDED;


        public String toString() {
            switch (this) {
                case LOGIN: {
                    return "login";
                }
                case LOGOUT: {
                    return "logout";
                }
                case REQUEST: {
                    return "request";
                }
                case LOGIN_FAILED: {
                    return "login-failed";
                }
                case LOGIN_SUCCEEDED: {
                    return "login-succeeded";
                }
            }
            throw new IllegalArgumentException("unknown operation: " + (Object)((Object)this));
        }
    }
}

