/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.description.ParsedVVSADL;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.module.chipster.ChipsterVVSADLParser;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class VVSADLParserTest {
    @BeforeTest
    public void init() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
    }

    @Test(groups={"smoke"})
    public void testRoundtrip() throws MicroarrayException, IOException {
        ParsedVVSADL description = new ParsedVVSADL("name", "package", "main comment");
        description.addInput(ParsedVVSADL.Input.createInput(ChipsterInputTypes.GENE_EXPRS, "input1"));
        description.addInput(ParsedVVSADL.Input.createInputSet(ChipsterInputTypes.GENE_EXPRS, "input2", ".ext"));
        description.addMetaInput(ParsedVVSADL.Input.createInput(ChipsterInputTypes.GENE_EXPRS, "metainput1"));
        description.addMetaInput(ParsedVVSADL.Input.createInputSet(ChipsterInputTypes.GENE_EXPRS, "metainput2", ".ext"));
        description.addOutput("output1");
        description.addMetaOutput("metaoutput1");
        description.addParameter(new ParsedVVSADL.Parameter("parameter1", VVSADLSyntax.ParameterType.DECIMAL, null, "1", "3", "2", "param comment 1"));
        description.addParameter(new ParsedVVSADL.Parameter("parameter2", VVSADLSyntax.ParameterType.ENUM, new String[]{"1", "2", "2"}, null, null, "2", "param comment 2"));
        Assert.assertEquals((String)description.inputs().get(0).getName(), (String)"input1");
        Assert.assertEquals((String)description.inputs().get(1).getPrefix(), (String)"input2");
        Assert.assertEquals((int)description.inputs().size(), (int)2);
        Assert.assertEquals((int)description.parameters().size(), (int)2);
        String string = description.toString();
        ParsedVVSADL parsedDescription = new ChipsterVVSADLParser().parse(string);
        String anotherString = parsedDescription.toString();
        System.out.println(anotherString);
        Assert.assertEquals((String)string, (String)anotherString);
    }

    public static void main(String[] args) throws MicroarrayException, IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        new VVSADLParserTest().testRoundtrip();
    }
}

