/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.Modifier;
import fi.csc.microarray.util.LookaheadStringReader;
import java.util.LinkedList;

public class RequestExecuter {
    private DataManager manager;

    public RequestExecuter(DataManager manager) {
        this.manager = manager;
    }

    public Feature execute(LookaheadStringReader request, DataBean data) {
        if ("/".equals(request.lookahead())) {
            return this.executeFeature(request, data);
        }
        return this.executeModifier(request, data);
    }

    private Feature executeModifier(LookaheadStringReader request, DataBean data) {
        String modifierName = request.readTo("(");
        Modifier modifier = this.manager.fetchModifier(modifierName);
        request.read();
        Feature feature = this.executeFeature(request, data);
        LinkedList<Feature> fl = new LinkedList<Feature>();
        fl.add(feature);
        modifier.setInputs(fl);
        request.read();
        return modifier.getOutput();
    }

    private Feature executeFeature(LookaheadStringReader request, DataBean data) {
        String name = request.readTo(")");
        return this.manager.fetchFeature(name, data);
    }
}

