/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationListModel;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.methods.threed.ColorScalePanel;
import fi.csc.microarray.client.visualisation.methods.threed.CoordinateArea;
import fi.csc.microarray.client.visualisation.methods.threed.DataModel;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;

public class Scatterplot3D
extends Visualisation
implements ActionListener,
KeyListener {
    private JPanel paramPanel;
    private JPanel settingsPanel;
    private AnnotateListPanel list;
    private JToggleButton rotateTool = new JToggleButton(VisualConstants.ROTATE_IMAGE);
    private JToggleButton handTool = new JToggleButton(VisualConstants.HAND_ICON);
    private JToggleButton selectTool = new JToggleButton(VisualConstants.ARROW_ICON);
    private Tool tool = Tool.ROTATE;
    private JButton toXY = new JButton(VisualConstants.XY_PLANE);
    private JButton toXZ = new JButton(VisualConstants.XZ_PLANE);
    private JButton toYZ = new JButton(VisualConstants.YZ_PLANE);
    private VisualisationListModel xListModel;
    private JComboBox xBox;
    private VisualisationListModel yListModel;
    private JComboBox yBox;
    private VisualisationListModel zListModel;
    private JComboBox zBox;
    private VisualisationListModel colorListModel;
    private JComboBox colorBox;
    private JButton useButton;
    private CoordinateArea coordinateArea;
    private static final Cursor ROTATE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(VisualConstants.ROTATE_CURSOR_IMAGE.getImage(), new Point(16, 16), "Rotate");
    private static final Cursor ROTATE_AND_ZOOM_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(VisualConstants.ROTATE_AND_ZOOM_CURSOR_IMAGE.getImage(), new Point(16, 16), "Rotate");
    private static DataModel dataModel = new DataModel();

    public JPanel getParameterPanel() {
        if (this.paramPanel == null || this.xListModel == null || this.xListModel.getData() != Session.getSession().getApplication().getSelectionManager().getSelectedDataBean()) {
            this.paramPanel = new JPanel();
            this.paramPanel.setLayout(new GridBagLayout());
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.rotateTool.addActionListener(this);
            this.rotateTool.setToolTipText("Rotate by dragging, zoom with scroll wheel or with Shift-button");
            this.handTool.addActionListener(this);
            this.handTool.setToolTipText("Move viewable part of the model by dragging it");
            this.selectTool.addActionListener(this);
            this.selectTool.setToolTipText("Selected datapoints are listed in tab 'Selected' below");
            this.rotateTool.addKeyListener(this);
            this.rotateTool.setSelected(true);
            this.toXY.addActionListener(this);
            this.toXY.setToolTipText("Show XY-plane");
            this.toXZ.addActionListener(this);
            this.toXZ.setToolTipText("Show XZ-plane");
            this.toYZ.addActionListener(this);
            this.toYZ.setToolTipText("Show YZ-plane");
            JPanel settings = this.createSettingsPanel();
            this.list = new AnnotateListPanel();
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Settings", settings);
            tabPane.addTab("Selected", this.list);
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.insets.set(5, 10, 5, 10);
            c.anchor = 18;
            c.fill = 2;
            c.weighty = 0.0;
            c.weightx = 1.0;
            this.paramPanel.add((Component)this.rotateTool, c);
            ++c.gridx;
            this.paramPanel.add((Component)this.handTool, c);
            ++c.gridx;
            this.paramPanel.add((Component)this.selectTool, c);
            ++c.gridy;
            c.gridx = 0;
            this.paramPanel.add((Component)this.toXY, c);
            ++c.gridx;
            this.paramPanel.add((Component)this.toXZ, c);
            ++c.gridx;
            this.paramPanel.add((Component)this.toYZ, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 3;
            c.insets.set(5, 0, 0, 0);
            c.fill = 1;
            c.weighty = 1.0;
            this.paramPanel.add((Component)tabPane, c);
        }
        this.setToolsEnabled(false);
        this.refreshAxisBoxes(Session.getSession().getApplication().getSelectionManager().getSelectedDataBean());
        return this.paramPanel;
    }

    public JPanel createSettingsPanel() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.xListModel = new VisualisationListModel();
        this.xBox = new JComboBox(this.xListModel);
        this.yListModel = new VisualisationListModel();
        this.yBox = new JComboBox(this.yListModel);
        this.zListModel = new VisualisationListModel();
        this.zBox = new JComboBox(this.zListModel);
        this.colorListModel = new VisualisationListModel();
        this.colorBox = new JComboBox(this.colorListModel);
        this.useButton = new JButton("Draw");
        this.useButton.addActionListener(this);
        JLabel xLabel = new JLabel("X-axis: ");
        xLabel.setForeground(Color.RED.darker().darker());
        JLabel yLabel = new JLabel("Y-axis: ");
        yLabel.setForeground(Color.GREEN.darker().darker());
        JLabel zLabel = new JLabel("Z-axis: ");
        zLabel.setForeground(Color.BLUE.darker().darker());
        JLabel colorLabel = new JLabel("Color: ");
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets.set(5, 10, 5, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 3;
        this.settingsPanel.add((Component)xLabel, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.xBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)yLabel, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.yBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)zLabel, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.zBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)colorLabel, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.colorBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.useButton, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.settingsPanel.add((Component)new JPanel(), c);
        return this.settingsPanel;
    }

    protected AnnotateListPanel getAnnotateList() {
        return this.list;
    }

    private void setToolsEnabled(boolean enabled) {
        this.rotateTool.setEnabled(enabled);
        this.handTool.setEnabled(enabled);
        this.selectTool.setEnabled(enabled);
        this.toXY.setEnabled(enabled);
        this.toXZ.setEnabled(enabled);
        this.toYZ.setEnabled(enabled);
    }

    private void refreshAxisBoxes(DataBean data) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        this.updateComboModel(this.xListModel, data);
        this.updateComboModel(this.yListModel, data);
        this.updateComboModel(this.zListModel, data);
        this.updateComboModel(this.colorListModel, data);
    }

    private void updateComboModel(VisualisationListModel model, DataBean data) {
        model.fillVariablesFor(data, VisualisationMethod.SCATTERPLOT);
    }

    public Tool getTool() {
        return this.tool;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useButton) {
            this.refreshAxisBoxes(Session.getSession().getApplication().getSelectionManager().getSelectedDataBean());
            Session.getSession().getApplication().setVisualisationMethod(VisualisationMethod.SCATTERPLOT3D);
            CoordinateArea.setPaintMode(CoordinateArea.PaintMode.PIXEL);
        } else if (source == this.toXY) {
            this.coordinateArea.movement.addRotationTask(Math.PI, 0.0, 0.0, 1000L, 15.0);
        } else if (source == this.toXZ) {
            this.coordinateArea.movement.addRotationTask(4.71238898038469, 0.0, 0.0, 1000L, 15.0);
        } else if (source == this.toYZ) {
            this.coordinateArea.movement.addRotationTask(Math.PI, -1.5707963267948966, 0.0, 1000L, 15.0);
        } else if (source == this.rotateTool || source == this.handTool || source == this.selectTool) {
            this.selectTool((JToggleButton)source);
        }
    }

    private void selectTool(JToggleButton button) {
        this.rotateTool.setSelected(button == this.rotateTool);
        this.handTool.setSelected(button == this.handTool);
        this.selectTool.setSelected(button == this.selectTool);
        if (button == this.rotateTool) {
            this.coordinateArea.setCursor(ROTATE_CURSOR);
            this.tool = Tool.ROTATE;
        } else if (button == this.handTool) {
            this.coordinateArea.setCursor(Cursor.getPredefinedCursor(13));
            this.tool = Tool.MOVE;
        } else if (button == this.selectTool) {
            this.coordinateArea.setCursor(Cursor.getDefaultCursor());
            this.tool = Tool.SELECT;
        }
    }

    public JComponent getVisualisation(DataBean data, Dimension size) throws Exception {
        this.refreshAxisBoxes(data);
        LinkedList<Visualisation.Variable> variables = new LinkedList<Visualisation.Variable>();
        variables.add((Visualisation.Variable)this.xBox.getSelectedItem());
        variables.add((Visualisation.Variable)this.yBox.getSelectedItem());
        variables.add((Visualisation.Variable)this.zBox.getSelectedItem());
        variables.add((Visualisation.Variable)this.colorBox.getSelectedItem());
        if (variables.size() >= 4 && variables.get(0) != null && variables.get(1) != null && variables.get(2) != null && variables.get(3) != null) {
            Iterable<String> identifier = data.fetchFeature("/column/*").asStrings();
            Iterable<Float> xValues = data.fetchFeature(((Visualisation.Variable)variables.get(0)).getExpression()).asFloats();
            Iterable<Float> yValues = data.fetchFeature(((Visualisation.Variable)variables.get(1)).getExpression()).asFloats();
            Iterable<Float> zValues = data.fetchFeature(((Visualisation.Variable)variables.get(2)).getExpression()).asFloats();
            Iterable<Float> cValues = data.fetchFeature(((Visualisation.Variable)variables.get(3)).getExpression()).asFloats();
            dataModel.setData(identifier, xValues, yValues, zValues, cValues);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            this.coordinateArea = new CoordinateArea(this);
            this.coordinateArea.addKeyListener(this);
            this.coordinateArea.requestFocus();
            panel.add((Component)this.coordinateArea, "Center");
            panel.add((Component)new ColorScalePanel(dataModel), "West");
            panel.setCursor(ROTATE_CURSOR);
            this.setToolsEnabled(true);
            return panel;
        }
        return this.getDefaultVisualisation();
    }

    public DataModel getDataModel() {
        return dataModel;
    }

    public void keyPressed(KeyEvent e) {
        if (this.tool == Tool.ROTATE) {
            if (e.isShiftDown()) {
                this.coordinateArea.setCursor(ROTATE_AND_ZOOM_CURSOR);
            } else {
                this.coordinateArea.setCursor(ROTATE_CURSOR);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.tool == Tool.ROTATE) {
            this.coordinateArea.setCursor(ROTATE_CURSOR);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getVisualiser().canVisualise(bean);
        return isTabular && bean.fetchFeature("/column/chip.*").exists();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tool {
        ROTATE,
        MOVE,
        SELECT;

    }
}

