/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationTaskManager;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.MultiChartPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(VisualisationPanel.class);
    private static final Color BG = Color.white;
    private static final int MAX_SIMULTANEOUS_VISUALISATIONS = 4;
    private ClientApplication application = Session.getSession().getApplication();
    private static final String EMPTY_PANEL_NAME = "empty";
    private static final String WAIT_PANEL_NAME = "wait";
    private static final String VISUALISATION_PANEL_NAME = "panel";
    private CardLayout viewChangerLayout = new CardLayout();
    private JPanel viewChangerPanel = new JPanel(this.viewChangerLayout);
    private JPanel lastVisualisationPanel;
    private VisualisationTaskManager visualisationTaskManager = new VisualisationTaskManager(this);
    private PropertyChangeListener visualisationChangeListener = new PropertyChangeListener(){
        private DataBean lastSelected = null;

        public void propertyChange(PropertyChangeEvent event) {
            if (event instanceof DatasetChoiceEvent) {
                if (VisualisationPanel.this.application.getSelectionManager().getSelectedDataBean() != this.lastSelected) {
                    VisualisationPanel.this.application.setVisualisationMethod(VisualisationMethod.NONE);
                }
                this.lastSelected = VisualisationPanel.this.application.getSelectionManager().getSelectedDataBean();
            } else if (event instanceof VisualisationMethodChangedEvent) {
                VisualisationMethodChangedEvent visualisationEvent = (VisualisationMethodChangedEvent)event;
                logger.debug((Object)("VisualisationPanel got VisualisationMethodChangedEvent with method: " + (Object)((Object)visualisationEvent.getNewMethod())));
                VisualisationPanel.this.visualisationTaskManager.visualise(VisualisationPanel.this.application.getSelectionManager().getSelectedDataBeans(), visualisationEvent.getNewMethod());
            }
        }
    };

    public VisualisationPanel() throws IOException {
        super(new BorderLayout());
        this.setBackground(BG);
        this.setMinimumSize(new Dimension(0, 0));
        this.viewChangerPanel.setBackground(BG);
        Dimension viewSize = new Dimension(700, 360);
        this.viewChangerPanel.setPreferredSize(viewSize);
        JPanel waitPanel = new JPanel(new BorderLayout());
        JLabel waitLabel = new JLabel("Visualising, please wait...");
        waitLabel.setFont(waitLabel.getFont().deriveFont(1));
        waitLabel.setHorizontalAlignment(0);
        waitPanel.add((Component)waitLabel, "Center");
        this.viewChangerPanel.add((Component)waitPanel, WAIT_PANEL_NAME);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setBackground(BG);
        this.viewChangerPanel.add((Component)emptyPanel, EMPTY_PANEL_NAME);
        this.showEmptyPanel();
        this.add((Component)this.viewChangerPanel, "Center");
        Session.getSession().getApplication().addPropertyChangeListener(this.visualisationChangeListener);
    }

    protected JPanel createVisualisation(List<DataBean> datas, VisualisationMethod method) throws MicroarrayException, IOException {
        JPanel panel = new JPanel(new BorderLayout());
        try {
            if (datas.size() == 1) {
                panel = this.createVisualisationPanel(datas.get(0), method);
            } else {
                JPanel[] panels = datas.size() >= 4 ? new JPanel[4] : new JPanel[datas.size()];
                ArrayList<ChartPanel> multiChartList = new ArrayList<ChartPanel>();
                for (int i = 0; i < panels.length; ++i) {
                    panels[i] = this.createVisualisationPanel(datas.get(i), method);
                    this.findChartPanelComponents(panels[i], multiChartList);
                }
                if (multiChartList.size() > 1) {
                    int columns;
                    int rows;
                    if (multiChartList.size() < 4) {
                        rows = 1;
                        columns = multiChartList.size();
                    } else {
                        rows = 2;
                        columns = 2;
                    }
                    panel = new JPanel(new GridLayout(rows, columns));
                    ArrayList<MultiChartPanel> multiChartPanelList = new ArrayList<MultiChartPanel>();
                    for (int i = 0; i < multiChartList.size() && i < 4; ++i) {
                        ChartPanel chart = (ChartPanel)multiChartList.get(i);
                        MultiChartPanel multiChartPanel = new MultiChartPanel(multiChartList, chart);
                        multiChartPanelList.add(multiChartPanel);
                        panel.add((Component)multiChartPanel);
                    }
                    logger.debug((Object)("Using multichartpanel. Panel count: " + multiChartPanelList.size()));
                } else {
                    panel = panels.length > 0 && panels[0].getComponentCount() > 0 ? panels[0] : new JPanel();
                }
            }
        }
        catch (Exception e) {
            this.application.reportException(e);
        }
        return panel;
    }

    private void findChartPanelComponents(JPanel parent, List<ChartPanel> charts) {
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (parent.getComponent(i) instanceof ChartPanel) {
                charts.add((ChartPanel)parent.getComponent(i));
                continue;
            }
            if (!(parent.getComponent(i) instanceof JPanel)) continue;
            this.findChartPanelComponents((JPanel)parent.getComponent(i), charts);
        }
    }

    private JPanel createVisualisationPanel(DataBean data, VisualisationMethod method) throws Exception {
        JPanel panelToShow = new JPanel(new BorderLayout());
        panelToShow.setSize(this.viewChangerPanel.getSize());
        panelToShow.setPreferredSize(this.viewChangerPanel.getSize());
        JPanel parametersPanel = method.getVisualiser().getParameterPanel();
        logger.debug((Object)("parametersPanel for method " + (Object)((Object)method) + " contains: " + parametersPanel));
        if (parametersPanel != null) {
            panelToShow.add((Component)parametersPanel, "East");
        }
        panelToShow.add((Component)method.getVisualiser().getVisualisation(data, panelToShow.getSize()), "Center");
        logger.debug((Object)"visualisationpanel contains following components:");
        for (Component component : panelToShow.getComponents()) {
            logger.debug((Object)("\t" + component));
        }
        return panelToShow;
    }

    protected void showVisualisationPanel(JPanel panel) {
        this.removeVisualisationPanel();
        this.lastVisualisationPanel = panel;
        panel.setBackground(BG);
        this.viewChangerPanel.add((Component)panel, VISUALISATION_PANEL_NAME);
        this.viewChangerLayout.show(this.viewChangerPanel, VISUALISATION_PANEL_NAME);
    }

    protected void showWaitPanel() {
        this.removeVisualisationPanel();
        this.viewChangerLayout.show(this.viewChangerPanel, WAIT_PANEL_NAME);
    }

    protected void showEmptyPanel() {
        this.removeVisualisationPanel();
        this.viewChangerLayout.show(this.viewChangerPanel, EMPTY_PANEL_NAME);
    }

    private void removeVisualisationPanel() {
        if (this.lastVisualisationPanel != null) {
            this.viewChangerPanel.remove(this.lastVisualisationPanel);
            this.viewChangerLayout.removeLayoutComponent(this.lastVisualisationPanel);
            this.lastVisualisationPanel = null;
        }
    }
}

