/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class MicroarrayTable
extends JXTable
implements ActionListener {
    private Clipboard systemClipboard;

    public MicroarrayTable() {
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.registerKeyboardAction(this, "Copy", copy, 0);
        this.registerKeyboardAction(this, "Paste", paste, 0);
        this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component cell = super.prepareRenderer(renderer, row, column);
        if (this.isColumnSelected(column) && this.isRowSelected(row)) {
            cell.setBackground(this.getSelectionBackground());
            cell.setForeground(this.getSelectionForeground());
        } else {
            cell.setBackground(this.getBackground());
            cell.setForeground(this.getForeground());
        }
        return cell;
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode == 2) {
            throw new IllegalArgumentException("MULTIPLE_INTERVAL_SELECTION cannot be used in MicroarrayTable");
        }
    }

    public void copy() {
        StringBuffer selectedValues = new StringBuffer();
        int numColsSelected = this.getSelectedColumnCount();
        int numRowsSelected = this.getSelectedRowCount();
        int[] rowsSelected = this.getSelectedRows();
        int[] colsSelected = this.getSelectedColumns();
        for (int row = 0; row < numRowsSelected; ++row) {
            for (int col = 0; col < numColsSelected; ++col) {
                selectedValues.append(this.getValueAt(rowsSelected[row], colsSelected[col]));
                if (col >= numColsSelected - 1) continue;
                selectedValues.append("\t");
            }
            selectedValues.append("\n");
        }
        StringSelection stringToClipboard = new StringSelection(selectedValues.toString());
        this.systemClipboard.setContents(stringToClipboard, stringToClipboard);
    }

    public void paste() {
        int startRow = this.getSelectedRows()[0];
        int startCol = this.getSelectedColumns()[0];
        try {
            String fromClipboard = (String)this.systemClipboard.getData(DataFlavor.stringFlavor);
            StringTokenizer tokenizedValues = new StringTokenizer(fromClipboard, "\n");
            int row = 0;
            while (tokenizedValues.hasMoreTokens()) {
                String rowString = tokenizedValues.nextToken();
                StringTokenizer tokenizedRowValues = new StringTokenizer(rowString, "\t");
                int col = 0;
                while (tokenizedRowValues.hasMoreTokens()) {
                    String cellValue = tokenizedRowValues.nextToken();
                    if (startRow + row < this.getRowCount() && startCol + col < this.getColumnCount() && this.isCellEditable(startRow + row, startCol + col)) {
                        this.setValueAt(cellValue, startRow + row, startCol + col);
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error occured while retrieving data from clipboard", "Clipboard error", 0);
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Requested data is not available", "Clipboard error", 0);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Clipboard is currently unavailable", "Clipboard error", 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Copy") == 0) {
            this.copy();
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            this.paste();
        }
    }
}

