/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.operation.ColoredCircleIcon;
import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationChoicePanel
extends JPanel
implements ListSelectionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(OperationChoicePanel.class);
    private ClientApplication application = Session.getSession().getApplication();
    private OperationPanel parent;
    private JList categoryList;
    private JList operationList;
    private OperationCategory selectedCategory;
    private ExecutionItem selectedOperation;

    public OperationChoicePanel(OperationPanel parent, Collection<OperationCategory> operationCategoryCollection) {
        super(new BorderLayout());
        Object[] categories;
        this.parent = parent;
        ArrayList<OperationCategory> operationCategories = Collections.list(Collections.enumeration(operationCategoryCollection));
        if (operationCategories != null) {
            categories = new Object[operationCategories.size()];
            for (int i = 0; i < operationCategories.size(); ++i) {
                categories[i] = operationCategories.get(i);
            }
        } else {
            categories = new Object[]{};
        }
        this.categoryList = new JList<Object>(categories);
        this.categoryList.setSelectionMode(0);
        this.categoryList.addListSelectionListener(this);
        this.categoryList.setCellRenderer(new CategoryListRenderer());
        this.categoryList.setPreferredSize(new Dimension(130, 0));
        this.categoryList.getInsets().right = 1;
        this.categoryList.setName("categoryList");
        this.operationList = new JList();
        this.operationList.setSelectionMode(0);
        this.operationList.addListSelectionListener(this);
        this.operationList.addMouseListener(new MouseClickListener());
        this.operationList.setPreferredSize(new Dimension(200, 0));
        this.operationList.getInsets().right = 1;
        this.operationList.setName("operationList");
        JScrollPane categoryListScroller = new JScrollPane(this.categoryList);
        JScrollPane operationListScroller = new JScrollPane(this.operationList);
        categoryListScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.OPERATION_LIST_BORDER_COLOR));
        operationListScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.OPERATION_LIST_BORDER_COLOR));
        this.add((Component)categoryListScroller, "West");
        this.add((Component)operationListScroller, "Center");
        Session.getSession().getApplication().addPropertyChangeListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selected;
        Object source = e.getSource();
        if (source == this.categoryList) {
            Object selected2 = this.categoryList.getSelectedValue();
            if (selected2 instanceof OperationCategory) {
                this.selectedCategory = (OperationCategory)selected2;
                this.selectedOperation = null;
                logger.debug((Object)("selected category has " + this.selectedCategory.getOperationList().size() + " operations"));
                this.operationList.setListData(this.selectedCategory.getOperationList());
                this.parent.enableAction(false);
            }
            this.parent.selectOperation(null);
        } else if (source == this.operationList && (selected = this.operationList.getSelectedValue()) instanceof ExecutionItem) {
            this.selectedOperation = (ExecutionItem)selected;
            this.parent.selectOperation(this.selectedOperation);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof DatasetChoiceEvent) {
            this.parent.selectOperation(this.selectedOperation);
        }
    }

    public class MouseClickListener
    implements MouseListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            OperationDefinition operationDefinition;
            Object selected;
            if (e.getButton() == 1 && e.getClickCount() > 1 && (selected = OperationChoicePanel.this.operationList.getSelectedValue()) instanceof OperationDefinition && OperationChoicePanel.this.application.getSelectionManager().getSelectedDataBeans().size() > 0 && !(operationDefinition = (OperationDefinition)selected).evaluateSuitabilityFor(OperationChoicePanel.this.application.getSelectionManager().getSelectedDataBeans()).isImpossible()) {
                OperationChoicePanel.this.application.executeOperation(operationDefinition, null);
            }
            if (e.getButton() == 3) {
                int index = OperationChoicePanel.this.operationList.locationToIndex(e.getPoint());
                Object clicked = OperationChoicePanel.this.operationList.getModel().getElementAt(index);
                Rectangle bounds = OperationChoicePanel.this.operationList.getCellBounds(index, index);
                if (bounds != null && clicked != null) {
                    boolean validPoint = bounds.contains(e.getPoint());
                    if (clicked instanceof OperationDefinition && validPoint) {
                        OperationDefinition operationDefinition2 = (OperationDefinition)clicked;
                        OperationPopupMenu popup = new OperationPopupMenu(operationDefinition2);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        }
    }

    public class OperationPopupMenu
    extends JPopupMenu {
        JMenuItem helpMenuItem;
        OperationDefinition operationDefinition;

        public OperationPopupMenu(OperationDefinition operationDefinition) {
            this.operationDefinition = operationDefinition;
            this.helpMenuItem = new JMenuItem("Help...");
            this.helpMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == OperationPopupMenu.this.helpMenuItem) {
                        OperationChoicePanel.this.application.viewHelpFor(OperationPopupMenu.this.operationDefinition);
                    }
                }
            });
            this.add(this.helpMenuItem);
        }
    }

    class CategoryListRenderer
    extends DefaultListCellRenderer {
        CategoryListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            comp.setIcon(new ColoredCircleIcon(((OperationCategory)list.getModel().getElementAt(index)).getColor()));
            return this;
        }
    }
}

