/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.auth.JaasAuthenticationProvider;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LoginTest {
    @Test
    public void loginTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        JaasAuthenticationProvider authProvider = new JaasAuthenticationProvider();
        Assert.assertTrue((boolean)authProvider.authenticate("neppi", "meppi".toCharArray()));
    }

    @Test
    public void stressLoginTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        int usernameMaxLength = 5;
        int passwordMaxLength = 5;
        int userCount = 200;
        int bruteCount = 100000;
        HashMap<String, String> users = new HashMap<String, String>();
        File testPasswdFile = File.createTempFile("chipster-passwd-test", null);
        PrintWriter pWriter = new PrintWriter(new BufferedWriter(new FileWriter(testPasswdFile)));
        for (int i = 0; i < userCount; ++i) {
            String username = this.getShortRandomString(usernameMaxLength);
            if (users.get(username) != null) continue;
            String password = this.getShortRandomString(passwordMaxLength);
            users.put(username, password);
            pWriter.println(username + ':' + password + this.getDescriptionColumn());
        }
        pWriter.close();
        File testJaasConfigFile = File.createTempFile("chipster-jaas-config-test", null);
        PrintWriter jWriter = new PrintWriter(new BufferedWriter(new FileWriter(testJaasConfigFile)));
        jWriter.println("Chipster {");
        jWriter.print("fi.csc.microarray.auth.SimpleFileLoginModule sufficient passwdFile=\"");
        jWriter.print(testPasswdFile.getPath());
        jWriter.println("\";");
        jWriter.println("};");
        jWriter.close();
        MicroarrayConfiguration.loadConfiguration();
        JaasAuthenticationProvider authProvider = new JaasAuthenticationProvider();
        System.setProperty("java.security.auth.login.config", testJaasConfigFile.getPath());
        int successCount = 0;
        int failCount = 0;
        for (int i = 0; i < bruteCount; ++i) {
            String realPassword;
            String brutePassword;
            String bruteUsername = this.getShortRandomString(usernameMaxLength);
            if (authProvider.authenticate(bruteUsername, (brutePassword = this.getShortRandomString(passwordMaxLength)).toCharArray())) {
                realPassword = (String)users.get(bruteUsername);
                Assert.assertNotNull((Object)realPassword);
                Assert.assertEquals((String)realPassword, (String)brutePassword);
                ++successCount;
                continue;
            }
            realPassword = (String)users.get(bruteUsername);
            if (realPassword != null) {
                Assert.assertFalse((boolean)realPassword.equals(brutePassword));
            }
            ++failCount;
        }
        System.out.println("successful: " + successCount + ", failed: " + failCount);
    }

    @Test
    public void randomTest() {
        for (int i = 0; i < 100; ++i) {
            System.out.println("plaa: " + this.getShortRandomString(3));
        }
    }

    private String getShortRandomString(int maxLength) {
        Random r = new Random();
        String longString = "";
        String result = "";
        boolean valid = false;
        while (!valid) {
            int length;
            longString = this.randomString();
            result = longString.substring(2, (length = r.nextInt(10000) % maxLength) + 1 + 2);
            if (result.indexOf(58) != -1) continue;
            valid = true;
        }
        return result;
    }

    private String randomString() {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return token;
    }

    private String getDescriptionColumn() {
        String result = "";
        Random r = new Random();
        int choice = r.nextInt(2345) % 3;
        switch (choice) {
            case 0: {
                result = "";
                break;
            }
            case 1: {
                result = ":";
                break;
            }
            case 2: {
                result = ":" + this.randomString();
            }
        }
        return result;
    }

    @Test
    public void getPassword() {
        System.out.println(UUID.randomUUID().toString());
        System.out.println(UUID.randomUUID().toString());
        System.out.println(UUID.randomUUID().toString());
        System.out.println(UUID.randomUUID().toString());
    }
}

