/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.r;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.OnDiskAnalysisJobBase;
import fi.csc.microarray.messaging.JobState;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RAnalysisJob
extends OnDiskAnalysisJobBase {
    static final Logger logger = Logger.getLogger(RAnalysisJob.class);
    private static String SCRIPT_SUCCESFUL_STRING = "nami-script-finished-succesfully";
    private static String SCRIPT_FAILED_STRING = "nami-script-finished-unsuccesfully";
    private int rTimeout;
    private CountDownLatch waitRLatch = new CountDownLatch(1);
    private Process process;

    protected RAnalysisJob() {
        this.rTimeout = Integer.parseInt(MicroarrayConfiguration.getValue("analyser", "RTimeout"));
    }

    protected void execute() throws IOException, MicroarrayException, InterruptedException {
        this.cancelCheck();
        this.updateStateDetail("initialising R", true);
        ArrayList<BufferedReader> inputReaders = new ArrayList<BufferedReader>();
        inputReaders.add(new BufferedReader(new StringReader(AnalysisDescription.getStaticInitialiser())));
        logger.debug((Object)("Job work dir: " + this.jobWorkDir.getPath()));
        inputReaders.add(new BufferedReader(new StringReader("setwd(\"" + this.jobWorkDir.getName() + "\")\n")));
        int i = 0;
        for (AnalysisDescription.ParameterDescription param : this.analysis.getParameters()) {
            String value = new String(this.inputMessage.getParameters().get(i));
            String rSnippet = RAnalysisJob.transformVariable(param.getName(), value, param.isNumeric());
            logger.debug((Object)("added parameter (" + rSnippet + ")"));
            inputReaders.add(new BufferedReader(new StringReader(rSnippet)));
            ++i;
        }
        String script = (String)this.analysis.getImplementation();
        inputReaders.add(new BufferedReader(new StringReader(script)));
        inputReaders.add(new BufferedReader(new StringReader("print(\"" + SCRIPT_SUCCESFUL_STRING + "\")\n")));
        this.cancelCheck();
        logger.debug((Object)"Getting a process.");
        this.process = this.resultHandler.getProcessPool().getProcess();
        this.updateStateDetail("running R", true);
        this.cancelCheck();
        logger.debug((Object)"About to start the R process monitor.");
        RProcessMonitor processMonitor = new RProcessMonitor();
        new Thread(processMonitor).start();
        logger.debug((Object)"Writing the input to R.");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        for (BufferedReader reader : inputReaders) {
            String line = reader.readLine();
            while (line != null) {
                writer.write(line);
                writer.newLine();
                line = reader.readLine();
            }
        }
        writer.flush();
        this.cancelCheck();
        logger.debug((Object)"Waiting for the script to finish.");
        this.waitRLatch.await(this.rTimeout, TimeUnit.SECONDS);
        this.cancelCheck();
        logger.debug((Object)("Done waiting for " + this.analysis.getFullName() + ", state is " + (Object)((Object)this.getState())));
        String output = processMonitor.getOutput();
        output = output.substring(output.indexOf("\n"));
        this.outputMessage.setOutputText(output);
        switch (this.getState()) {
            case RUNNING: {
                this.updateState(JobState.TIMEOUT, "R script exceeded timeout", false);
                throw new AnalysisException("Timeout occured before the analysis finished.");
            }
            case FAILED: {
                StringWriter errorWriter = new StringWriter();
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                String line = errorReader.readLine();
                while (line != null) {
                    errorWriter.write(line + "\n");
                    line = errorReader.readLine();
                }
                this.outputMessage.setOutputText(output + "\n" + errorWriter.toString());
                throw new AnalysisException("Error occured when executing the analysis.");
            }
            case COMPLETED: {
                this.updateState(JobState.RUNNING, "R script finished successfully", true);
                break;
            }
            default: {
                String errorString = "Unexpected process end state: " + this.getState().toString();
                logger.error((Object)(this.inputMessage.getMessageID() + ": " + errorString));
                throw new AnalysisException(errorString);
            }
        }
    }

    protected void preExecute() throws Exception {
        super.preExecute();
    }

    protected void postExecute() throws Exception {
        super.postExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        try {
            if (this.process != null) {
                this.resultHandler.getProcessPool().releaseProcess(this.process, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when releasing process. ", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }

    public static String transformVariable(String name, String value, boolean isNumeric) {
        if (!isNumeric) {
            value = "\"" + value + "\"";
        }
        name = name.replaceAll(" ", "_");
        return name + " <- " + value;
    }

    protected void cancelRequested() {
        this.waitRLatch.countDown();
    }

    private class RProcessMonitor
    implements Runnable {
        private StringBuffer output;

        private RProcessMonitor() {
        }

        public void run() {
            logger.debug((Object)"R process monitor started.");
            this.output = new StringBuffer("");
            BufferedReader reader = new BufferedReader(new InputStreamReader(RAnalysisJob.this.process.getInputStream()));
            boolean readMore = true;
            try {
                String line = reader.readLine();
                while (readMore) {
                    if (line == null || line.contains(SCRIPT_FAILED_STRING)) {
                        logger.debug((Object)("R monitor read: " + line));
                        RAnalysisJob.this.updateState(JobState.FAILED, "R script failed", false);
                        readMore = false;
                    } else if (line.contains(SCRIPT_SUCCESFUL_STRING)) {
                        RAnalysisJob.this.updateState(JobState.COMPLETED, "R script finished successfully", false);
                        readMore = false;
                    } else {
                        this.output.append(line + "\n");
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                logger.debug((Object)"Error in monitoring R process.");
                RAnalysisJob.this.updateState(JobState.ERROR, "R monitor error", false);
            }
            RAnalysisJob.this.waitRLatch.countDown();
        }

        public String getOutput() {
            return this.output.toString();
        }
    }
}

