/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class AnalysisDescriptionRepository {
    private static final Logger logger = Logger.getLogger(AnalysisDescriptionRepository.class);
    private LinkedHashMap<String, AnalysisDescription> descriptions = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisDescription> visibleDescriptions = new LinkedHashMap();
    private LinkedList<AnalysisHandler> handlers = new LinkedList();

    public void addAnalysisHandler(AnalysisHandler handler) {
        this.handlers.add(handler);
    }

    public void loadOperation(String sourceResourceName, boolean hidden) throws AnalysisException {
        AnalysisDescription description = this.loadDescription(sourceResourceName);
        this.addDescription(description, hidden);
    }

    private AnalysisDescription loadDescription(String sourceResourceName) throws AnalysisException {
        for (AnalysisHandler handler : this.handlers) {
            logger.debug((Object)("using handler " + handler.getClass().getSimpleName() + ", checking " + sourceResourceName));
            if (!handler.supports(sourceResourceName)) continue;
            return handler.handle(sourceResourceName);
        }
        throw new IllegalArgumentException("none of the loaded handlers support " + sourceResourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDescription(AnalysisDescription description, boolean hidden) {
        logger.debug((Object)("added operation " + description.getFullName()));
        AnalysisDescriptionRepository analysisDescriptionRepository = this;
        synchronized (analysisDescriptionRepository) {
            this.descriptions.put(description.getFullName(), description);
            if (!hidden) {
                this.visibleDescriptions.put(description.getFullName(), description);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisDescription getDescription(String fullName) throws AnalysisException {
        AnalysisDescription desc;
        AnalysisDescriptionRepository analysisDescriptionRepository = this;
        synchronized (analysisDescriptionRepository) {
            desc = this.descriptions.get(fullName);
        }
        if (desc != null && !desc.isUptodate()) {
            AnalysisDescription newDescription = this.loadDescription(desc.getSourceResourceName());
            AnalysisDescriptionRepository analysisDescriptionRepository2 = this;
            synchronized (analysisDescriptionRepository2) {
                this.descriptions.remove(fullName);
                this.descriptions.put(newDescription.getFullName(), newDescription);
                assert (newDescription.getFullName().equals(fullName));
                if (this.visibleDescriptions.containsKey(fullName)) {
                    this.visibleDescriptions.remove(fullName);
                    this.visibleDescriptions.put(newDescription.getFullName(), newDescription);
                }
            }
            desc = newDescription;
        }
        return desc;
    }

    public StringBuffer serialiseAsStringBuffer() {
        StringBuffer buf = new StringBuffer();
        for (AnalysisDescription description : this.visibleDescriptions.values()) {
            buf.append(description.getVVSADL());
        }
        return buf;
    }
}

