/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.fest.swing.util.ImageException;
import org.fest.util.Files;
import org.fest.util.Strings;

public final class ScreenshotTaker {
    public static final String PNG_EXTENSION = "png";
    private final Robot robot;

    public ScreenshotTaker() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            throw new ImageException("Unable to create AWT Robot", e);
        }
    }

    public void saveDesktopAsPng(String imageFilePath) {
        this.validate(imageFilePath);
        BufferedImage screenshot = this.takeDesktopScreenshot();
        try {
            ImageIO.write((RenderedImage)screenshot, PNG_EXTENSION, Files.newFile((String)imageFilePath));
        }
        catch (IOException e) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"Unable to save screenshot as ", Strings.quote((String)imageFilePath)}), e);
        }
    }

    public BufferedImage takeDesktopScreenshot() {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return this.robot.createScreenCapture(screen);
    }

    private void validate(String imageFilePath) {
        if (Strings.isEmpty((String)imageFilePath)) {
            throw new ImageException("The image path cannot be empty");
        }
        if (!imageFilePath.endsWith(PNG_EXTENSION)) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"The image file should be a ", PNG_EXTENSION.toUpperCase()}));
        }
    }
}

