/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture.util;

import java.awt.Component;
import java.awt.Window;
import java.util.concurrent.TimeUnit;
import org.fest.swing.ComponentFinder;
import org.fest.swing.ComponentLookupException;
import org.fest.swing.ComponentMatcher;
import org.fest.swing.RobotFixture;
import org.fest.swing.fixture.WindowFixture;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WindowFinderTemplate<T extends Window> {
    private static final long TIMEOUT = 5000L;
    private String windowName;
    private Class<? extends T> windowType;
    private long timeout = 5000L;

    WindowFinderTemplate(String windowName) {
        if (Strings.isEmpty((String)windowName)) {
            throw new IllegalArgumentException("The name of the window to find should not be empty or null");
        }
        this.windowName = windowName;
    }

    WindowFinderTemplate(Class<? extends T> windowType) {
        this.windowType = windowType;
        if (windowType == null) {
            throw new IllegalArgumentException("The type of window to find should not be null");
        }
    }

    WindowFinderTemplate withTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.timeout = timeout;
        return this;
    }

    WindowFinderTemplate withTimeout(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Time unit cannot be null");
        }
        return this.withTimeout(unit.toMillis(timeout));
    }

    public abstract WindowFixture<T> using(RobotFixture var1);

    protected final T findWindowWith(RobotFixture robot) {
        Component c;
        ComponentFinder finder = robot.finder();
        ComponentMatcher matcher = this.matcher();
        long start = System.currentTimeMillis();
        while (true) {
            c = null;
            try {
                c = finder.find(matcher);
            }
            catch (ComponentLookupException e) {
                if (this.isTimeout(start)) {
                    throw this.cannotFindWindow();
                }
                this.sleep();
                continue;
            }
            break;
        }
        return (T)((Window)c);
    }

    private ComponentMatcher matcher() {
        if (this.searchingByType()) {
            return this.typeMatcher();
        }
        return this.nameMatcher();
    }

    protected abstract ComponentMatcher nameMatcher();

    private ComponentMatcher typeMatcher() {
        return new ComponentMatcher(){

            public boolean matches(Component c) {
                return c != null && WindowFinderTemplate.this.windowType().isAssignableFrom(c.getClass());
            }
        };
    }

    private boolean isTimeout(long startTime) {
        long timePassed = System.currentTimeMillis() - startTime;
        return timePassed >= this.timeout;
    }

    private ComponentLookupException cannotFindWindow() {
        String message = "Cannot find window ";
        message = this.searchingByType() ? Strings.concat((Object[])new Object[]{message, "of type ", this.windowType().getName()}) : Strings.concat((Object[])new Object[]{message, "with name ", Strings.quote((String)this.windowName())});
        throw new ComponentLookupException(message);
    }

    private void sleep() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected final String windowName() {
        return this.windowName;
    }

    protected final Class<? extends T> windowType() {
        return this.windowType;
    }

    protected final boolean searchingByType() {
        return this.windowType != null;
    }
}

