/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.swing.ComponentMatcher;
import org.fest.swing.RobotFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.DialogFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JCheckBoxFixture;
import org.fest.swing.fixture.JComboBoxFixture;
import org.fest.swing.fixture.JLabelFixture;
import org.fest.swing.fixture.JMenuItemFixture;
import org.fest.swing.fixture.JOptionPaneFixture;
import org.fest.swing.fixture.JSliderFixture;
import org.fest.swing.fixture.JSpinnerFixture;
import org.fest.swing.fixture.JTabbedPaneFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.swing.fixture.JToolBarFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerFixture<T extends Container>
extends ComponentFixture<T> {
    public ContainerFixture(RobotFixture robot, Class<? extends T> type) {
        super(robot, robot.finder().findByType(type));
    }

    public ContainerFixture(RobotFixture robot, String name, Class<? extends T> type) {
        super(robot, robot.finder().findByName(name, type));
    }

    public ContainerFixture(RobotFixture robot, T target) {
        super(robot, target);
    }

    public final JButtonFixture button(String name) {
        return new JButtonFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JButton.class));
    }

    public final JCheckBoxFixture checkBox(String name) {
        return new JCheckBoxFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JCheckBox.class));
    }

    public final JComboBoxFixture comboBox(String name) {
        return new JComboBoxFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JComboBox.class));
    }

    public final DialogFixture dialog(String name) {
        return new DialogFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, Dialog.class));
    }

    public final JLabelFixture label(String name) {
        return new JLabelFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JLabel.class));
    }

    public final JMenuItemFixture menuItem(String name) {
        return new JMenuItemFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JMenuItem.class));
    }

    public final JMenuItemFixture menuItem(String ... path) {
        JMenuItemMatcher m = new JMenuItemMatcher(Strings.join((String[])path).with("|"));
        Component item = this.robot.finder().find((Container)this.target, m);
        Assertions.assertThat((Object)item).isInstanceOf(JMenuItem.class);
        return new JMenuItemFixture(this.robot, (JMenuItem)item);
    }

    public final JOptionPaneFixture optionPane() {
        return new JOptionPaneFixture(this.robot);
    }

    public final JSliderFixture slider(String name) {
        return new JSliderFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JSlider.class));
    }

    public final JSpinnerFixture spinner(String name) {
        return new JSpinnerFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JSpinner.class));
    }

    public final JTabbedPaneFixture tabbedPane(String name) {
        return new JTabbedPaneFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JTabbedPane.class));
    }

    public final JTextComponentFixture textBox(String name) {
        return new JTextComponentFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JTextComponent.class));
    }

    public final JToolBarFixture toolBar(String name) {
        return new JToolBarFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JToolBar.class));
    }

    public final JTreeFixture tree(String name) {
        return new JTreeFixture(this.robot, this.robot.finder().findByName((Container)this.target, name, JTree.class));
    }

    private static class JMenuItemMatcher
    extends abbot.finder.matchers.JMenuItemMatcher
    implements ComponentMatcher {
        public JMenuItemMatcher(String label) {
            super(label);
        }
    }
}

