/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing;

import abbot.finder.AWTHierarchy;
import abbot.finder.Hierarchy;
import abbot.finder.TestHierarchy;
import abbot.tester.Robot;
import abbot.tester.WindowTracker;
import abbot.util.Bugs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collection;
import javax.swing.JMenuItem;
import org.fest.swing.ComponentFinder;
import org.fest.swing.Condition;
import org.fest.swing.ScreenLock;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RobotFixture {
    private static final int WINDOW_DELAY = 20000;
    private Robot robot;
    private WindowTracker windowTracker;
    private final Hierarchy hierarchy;
    private final ComponentFinder finder;

    public static RobotFixture robotWithNewAwtHierarchy() {
        return new RobotFixture((Hierarchy)new TestHierarchy());
    }

    public static RobotFixture robotWithCurrentAwtHierarchy() {
        return new RobotFixture((Hierarchy)new AWTHierarchy());
    }

    private RobotFixture(Hierarchy hierarchy) {
        ScreenLock.instance().acquire(this);
        this.hierarchy = hierarchy;
        this.finder = new ComponentFinder(this.hierarchy);
        this.windowTracker = WindowTracker.getTracker();
        this.robot = this.newRobot();
    }

    private Robot newRobot() {
        Robot robot = new Robot();
        robot.reset();
        if (Bugs.hasMultiClickFrameBug()) {
            robot.delay(500);
        }
        return robot;
    }

    public ComponentFinder finder() {
        return this.finder;
    }

    public void showWindow(Window w) {
        this.showWindow(w, null, true);
    }

    public void showWindow(Window w, Dimension size) {
        this.showWindow(w, size, true);
    }

    public void showWindow(final Window w, final Dimension size, final boolean pack) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (pack) {
                    RobotFixture.this.packAndEnsureSafePosition(w);
                }
                if (size != null) {
                    w.setSize(size);
                }
                w.setVisible(true);
            }
        });
        this.waitForWindow(w);
    }

    private void waitForWindow(Window w) {
        long start = System.currentTimeMillis();
        while (Robot.getEventMode() == Robot.EM_ROBOT && !this.windowTracker.isWindowReady(w) || !w.isShowing()) {
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 20000L) {
                throw new RuntimeException(Strings.concat((Object[])new Object[]{"Timed out waiting for Window to open (", String.valueOf(elapsed), "ms)"}));
            }
            this.robot.sleep();
        }
    }

    private void packAndEnsureSafePosition(Window w) {
        w.pack();
        w.setLocation(100, 100);
    }

    public void focus(Component c) {
        this.robot.focus(c);
    }

    public void wait(Condition condition) {
        this.robot.wait((abbot.script.Condition)condition);
    }

    public void invokeLater(Component c, Runnable action) {
        this.robot.invokeLater(c, action);
    }

    public void invokeAndWait(Component c, Runnable action) {
        this.robot.invokeAndWait(c, action);
    }

    public void cleanUp() {
        this.disposeWindows();
        this.mouseRelease();
        this.robot = null;
        this.windowTracker = null;
        ScreenLock.instance().release(this);
    }

    private void disposeWindows() {
        for (Window w : this.roots()) {
            this.hierarchy.dispose(w);
            w.setVisible(false);
            w.dispose();
        }
    }

    private Collection<Window> roots() {
        return this.hierarchy.getRoots();
    }

    private void mouseRelease() {
        if (this.robot == null) {
            return;
        }
        int buttons = Robot.getState().getButtons();
        if (buttons != 0) {
            this.robot.mouseRelease(buttons);
        }
    }

    public void selectMenuItem(JMenuItem target) {
        this.robot.selectMenuItem((Component)target);
    }
}

