/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.jdesktop.swingx.JXPanel;

public class JXTitledSeparator
extends JXPanel {
    private JLabel label;
    private JSeparator leftSeparator;
    private JSeparator rightSeparator;

    public JXTitledSeparator() {
        this("Untitled");
    }

    public JXTitledSeparator(String title) {
        this(title, 10, null);
    }

    public JXTitledSeparator(String title, int horizontalAlignment) {
        this(title, horizontalAlignment, null);
    }

    public JXTitledSeparator(String title, int horizontalAlignment, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.label = new JLabel(title){

            public void updateUI() {
                super.updateUI();
                JXTitledSeparator.this.updateTitle();
            }
        };
        this.label.setIcon(icon);
        this.label.setHorizontalAlignment(horizontalAlignment);
        this.leftSeparator = new JSeparator();
        this.rightSeparator = new JSeparator();
        this.layoutSeparator();
        this.updateTitle();
        this.setOpaque(false);
    }

    protected void updateTitle() {
        Font f;
        if (this.label == null) {
            return;
        }
        Color c = this.label.getForeground();
        if (c == null || c instanceof ColorUIResource) {
            this.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        }
        if ((f = this.label.getFont()) == null || f instanceof FontUIResource) {
            this.setFont(UIManager.getFont("TitledBorder.font"));
        }
    }

    private void layoutSeparator() {
        this.removeAll();
        switch (this.label.getHorizontalAlignment()) {
            case 2: 
            case 7: 
            case 10: {
                this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.rightSeparator, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                this.add((Component)this.rightSeparator, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                break;
            }
            default: {
                this.add((Component)this.leftSeparator, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.rightSeparator, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }

    public void setTitle(String title) {
        String old = this.getTitle();
        this.label.setText(title);
        this.firePropertyChange("title", old, this.getTitle());
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setHorizontalAlignment(int alignment) {
        int old = this.getHorizontalAlignment();
        this.label.setHorizontalAlignment(alignment);
        if (old != this.getHorizontalAlignment()) {
            this.layoutSeparator();
        }
        this.firePropertyChange("horizontalAlignment", old, this.getHorizontalAlignment());
    }

    public int getHorizontalAlignment() {
        return this.label.getHorizontalAlignment();
    }

    public void setHorizontalTextPosition(int position) {
        int old = this.getHorizontalTextPosition();
        this.label.setHorizontalTextPosition(position);
        this.firePropertyChange("horizontalTextPosition", old, this.getHorizontalTextPosition());
    }

    public int getHorizontalTextPosition() {
        return this.label.getHorizontalTextPosition();
    }

    public void setIcon(Icon icon) {
        Icon old = this.getIcon();
        this.label.setIcon(icon);
        this.firePropertyChange("icon", old, this.getIcon());
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setForeground(Color foreground) {
        if (this.label != null) {
            this.label.setForeground(foreground);
        }
        super.setForeground(foreground);
    }

    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
        super.setFont(font);
    }
}

