/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

public class AssertJUnit {
    protected AssertJUnit() {
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            AssertJUnit.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        AssertJUnit.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        AssertJUnit.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        AssertJUnit.assertFalse(null, condition);
    }

    public static void fail(String message) {
        if (null == message) {
            message = "";
        }
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        AssertJUnit.fail(null);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        AssertJUnit.failNotEquals(message, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new AssertionError((Object)AssertJUnit.format(message, expected, actual));
    }

    public static void assertEquals(String expected, String actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                AssertJUnit.failNotEquals(message, new Double(expected), new Double(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertJUnit.failNotEquals(message, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        AssertJUnit.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                AssertJUnit.failNotEquals(message, new Float(expected), new Float(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertJUnit.failNotEquals(message, new Float(expected), new Float(actual));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        AssertJUnit.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, long expected, long actual) {
        AssertJUnit.assertEquals(message, new Long(expected), new Long(actual));
    }

    public static void assertEquals(long expected, long actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        AssertJUnit.assertEquals(message, (Object)expected, (Object)actual);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte expected, byte actual) {
        AssertJUnit.assertEquals(message, new Byte(expected), new Byte(actual));
    }

    public static void assertEquals(byte expected, byte actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char expected, char actual) {
        AssertJUnit.assertEquals(message, new Character(expected), new Character(actual));
    }

    public static void assertEquals(char expected, char actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, short expected, short actual) {
        AssertJUnit.assertEquals(message, new Short(expected), new Short(actual));
    }

    public static void assertEquals(short expected, short actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int expected, int actual) {
        AssertJUnit.assertEquals(message, new Integer(expected), new Integer(actual));
    }

    public static void assertEquals(int expected, int actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertNotNull(Object object) {
        AssertJUnit.assertNotNull(null, object);
    }

    public static void assertNotNull(String message, Object object) {
        AssertJUnit.assertTrue(message, object != null);
    }

    public static void assertNull(Object object) {
        AssertJUnit.assertNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        AssertJUnit.assertTrue(message, object == null);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        AssertJUnit.failNotSame(message, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        AssertJUnit.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            AssertJUnit.failSame(message);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        AssertJUnit.assertNotSame(null, expected, actual);
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        AssertJUnit.assertEquals("", expected, actual);
    }

    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        if (expected == actual) {
            return;
        }
        if (null == expected) {
            AssertJUnit.fail("expected a null array, but not null found. " + message);
        }
        if (null == actual) {
            AssertJUnit.fail("expected not null array, but null found. " + message);
        }
        AssertJUnit.assertEquals("arrays don't have the same size. " + message, expected.length, actual.length);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertJUnit.fail("arrays differ firstly at element [" + i + "]; " + AssertJUnit.format(message, expected[i], actual[i]));
        }
    }

    private static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        AssertJUnit.fail(formatted + "expected not same");
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        AssertJUnit.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        AssertJUnit.fail(AssertJUnit.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

