/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.console.command.AmqBrowseCommand;
import org.apache.activemq.console.command.BstatCommand;
import org.apache.activemq.console.command.ListCommand;
import org.apache.activemq.console.command.PurgeCommand;
import org.apache.activemq.console.command.QueryCommand;
import org.apache.activemq.console.command.ShutdownCommand;
import org.apache.activemq.console.command.StartCommand;
import org.apache.activemq.console.formatter.CommandShellOutputFormatter;
import org.apache.activemq.console.formatter.GlobalWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellCommand
extends AbstractCommand {
    private boolean interactive;
    private String[] helpFile;

    public ShellCommand() {
        this(false);
    }

    public ShellCommand(boolean interactive) {
        this.interactive = interactive;
        this.helpFile = new String[]{interactive ? "Usage: [task] [task-options] [task data]" : "Usage: Main [--extdir <dir>] [task] [task-options] [task data]", "", "Tasks (default task is start):", "    start           - Creates and starts a broker using a configuration file, or a broker URI.", "    stop            - Stops a running broker specified by the broker name.", "    list            - Lists all available brokers in the specified JMX context.", "    query           - Display selected broker component's attributes and statistics.", "    browse          - Display selected messages in a specified destination.", "", "Task Options (Options specific to each task):", "    --extdir <dir>  - Add the jar files in the directory to the classpath.", "    --version       - Display the version information.", "    -h,-?,--help    - Display this help information. To display task specific help, use " + (interactive ? "" : "Main ") + "[task] -h,-?,--help", "", "Task Data:", "    - Information needed by each specific task.", ""};
    }

    public static int main(String[] args, InputStream in, PrintStream out) {
        GlobalWriter.instantiate(new CommandShellOutputFormatter(out));
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(args));
        ShellCommand main = new ShellCommand();
        try {
            main.execute(tokens);
            return 0;
        }
        catch (Exception e) {
            GlobalWriter.printException(e);
            return -1;
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        if (tokens.size() > 0) {
            String taskToken = tokens.remove(0);
            if (taskToken.equals("start")) {
                new StartCommand().execute(tokens);
            } else if (taskToken.equals("stop")) {
                new ShutdownCommand().execute(tokens);
            } else if (taskToken.equals("list")) {
                new ListCommand().execute(tokens);
            } else if (taskToken.equals("query")) {
                new QueryCommand().execute(tokens);
            } else if (taskToken.equals("bstat")) {
                new BstatCommand().execute(tokens);
            } else if (taskToken.equals("browse")) {
                new AmqBrowseCommand().execute(tokens);
            } else if (taskToken.equals("purge")) {
                new PurgeCommand().execute(tokens);
            } else if (taskToken.equals("help")) {
                this.printHelp();
            } else {
                this.printHelp();
            }
        } else {
            this.printHelp();
        }
    }

    @Override
    protected void printHelp() {
        GlobalWriter.printHelp(this.helpFile);
    }
}

