/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.table;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.BasicFeature;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureFactory;
import fi.csc.microarray.databeans.features.FeatureFactoryBase;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.util.LookaheadLineReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TableColumnFactory
extends FeatureFactoryBase {
    private static final Logger logger = Logger.getLogger(TableColumnFactory.class);
    private static final Pattern ROW_TOKENISER_REGEX = Pattern.compile("\t");

    public Feature createFeature(String namePostfix, DataBean bean) {
        try {
            return new TableColumn(namePostfix, bean, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage() + " (when parsing table data out of " + bean.getName() + ")", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableColumn
    extends BasicFeature {
        private MatrixParseSettings settings;
        private int[] columnIndexes;

        public TableColumn(String namePostfix, DataBean bean, FeatureFactory factory) throws IOException, MicroarrayException {
            super(bean, factory);
            this.settings = this.inferSettings(bean);
            LinkedList<Integer> indexCollector = new LinkedList<Integer>();
            int c = 0;
            for (Column column : this.settings.columns.values()) {
                String[] queryParts;
                boolean match = false;
                match = namePostfix.contains("*") ? (queryParts = namePostfix.split("\\*")).length == 0 || column.name.startsWith(queryParts[0]) : column.name.equals(namePostfix);
                if (match) {
                    indexCollector.add(c);
                    logger.debug("created column feature for column " + column.name + " (index " + c + ")");
                }
                ++c;
            }
            if (indexCollector.isEmpty()) {
                this.columnIndexes = null;
            } else {
                this.columnIndexes = new int[indexCollector.size()];
                for (int i = 0; i < indexCollector.size(); ++i) {
                    this.columnIndexes[i] = (Integer)indexCollector.get(i);
                }
            }
        }

        @Override
        public Iterable<Float> asFloats() throws MicroarrayException {
            if (this.columnIndexes == null) {
                return null;
            }
            return new ColumnIterable<Float>(this.getDataBean(), this.settings, this.columnIndexes[0], true);
        }

        @Override
        public Iterable<String> asStrings() throws MicroarrayException {
            if (this.columnIndexes == null) {
                return null;
            }
            return new ColumnIterable<String>(this.getDataBean(), this.settings, this.columnIndexes[0], false);
        }

        @Override
        public Table asTable() throws MicroarrayException {
            if (this.columnIndexes == null) {
                return null;
            }
            return new DynamicTable(this.getDataBean(), this.settings, this.columnIndexes);
        }

        public MatrixParseSettings inferSettings(DataBean bean) throws IOException, MicroarrayException {
            String[] columnNames;
            LookaheadLineReader source = new LookaheadLineReader(new BufferedReader(new InputStreamReader(bean.getContentByteStream())));
            MatrixParseSettings settings = new MatrixParseSettings();
            if (source.peekLine() != null && source.peekLine().contains("[CEL]")) {
                logger.debug("parsing cel type");
                settings.headerTerminator = "CellHeader=";
                settings.footerStarter = "\n[MASKS]";
                settings.hasColumnNames = true;
            } else {
                logger.debug("parsing generic type");
                logger.debug("first line has " + TableColumn.tokeniseRow(source.peekLine(1)).length + " tokens and is " + source.peekLine(1));
                logger.debug("second line has " + TableColumn.tokeniseRow(source.peekLine(2)).length + " tokens and is " + source.peekLine(2));
            }
            if (settings.headerTerminator != null) {
                TableColumn.parseAwayHeader(source, settings);
            }
            if (settings.hasColumnNames) {
                logger.debug("column name row " + source.peekLine());
                columnNames = TableColumn.tokeniseRow(source.readLine());
            } else {
                logger.debug("no column names, we use numbering");
                columnNames = new String[TableColumn.tokeniseRow(source.peekLine()).length];
                for (int i = 0; i < columnNames.length; ++i) {
                    columnNames[i] = "column" + i;
                }
            }
            int dataColumnCount = TableColumn.tokeniseRow(source.peekLine(1)).length;
            if (dataColumnCount == columnNames.length + 1) {
                logger.debug("we have one column for row names");
                String[] newColumnNames = new String[columnNames.length + 1];
                System.arraycopy(columnNames, 0, newColumnNames, 1, columnNames.length);
                newColumnNames[0] = " ";
                columnNames = newColumnNames;
            } else if (dataColumnCount > columnNames.length + 1) {
                throw new MicroarrayException("table parse error: " + columnNames.length + " column names, but " + dataColumnCount + " values");
            }
            logger.debug("parsed matrix has " + columnNames.length + " columns, column names came with data: " + settings.hasColumnNames);
            for (String columnName : columnNames) {
                logger.debug("added column " + columnName);
                settings.columns.put(columnName, new Column(columnName));
            }
            return settings;
        }

        public static void parseAwayHeader(LookaheadLineReader source, MatrixParseSettings settings) throws IOException {
            while (!source.peekLine().contains(settings.headerTerminator)) {
                source.readLine();
            }
            String separatingLine = source.peekLine();
            String endOfHeader = separatingLine.substring(separatingLine.indexOf(settings.headerTerminator), separatingLine.indexOf(settings.headerTerminator) + settings.headerTerminator.length());
            source.read(endOfHeader.length());
        }

        public static String[] tokeniseRow(String row) {
            if (row == null) {
                return new String[0];
            }
            String[] result = ROW_TOKENISER_REGEX.split(row);
            if (row.endsWith("\t")) {
                String[] fullResult = new String[result.length + 1];
                System.arraycopy(result, 0, fullResult, 0, result.length);
                fullResult[result.length] = "";
                result = fullResult;
            }
            return result;
        }
    }

    private static class MatrixParseSettings {
        String headerTerminator = null;
        String footerStarter = null;
        boolean hasColumnNames = true;
        LinkedHashMap<String, Column> columns = new LinkedHashMap();

        private MatrixParseSettings() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DynamicTable
    implements Table {
        private LookaheadLineReader source;
        private boolean headerParsed = false;
        private MatrixParseSettings settings;
        private int[] columnNumbers;
        private HashMap<String, String> values;
        private String[] columnNames;

        public DynamicTable(DataBean bean, MatrixParseSettings settings, int[] columnNumbers) {
            try {
                this.source = new LookaheadLineReader(new BufferedReader(new InputStreamReader(bean.getContentByteStream())));
                this.settings = settings;
                this.columnNumbers = columnNumbers;
                this.columnNames = settings.columns.keySet().toArray(new String[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean nextRow() {
            try {
                if (this.source.peekLine() == null || this.settings.footerStarter != null && this.source.peekLine().contains(this.settings.footerStarter) || this.headerParsed && "".equals(this.source.peekLine().trim())) {
                    this.values = null;
                    return false;
                }
                if (!this.headerParsed) {
                    if (this.settings.headerTerminator != null) {
                        TableColumn.parseAwayHeader(this.source, this.settings);
                    }
                    if (this.settings.hasColumnNames) {
                        this.source.readLine();
                    }
                    this.headerParsed = true;
                }
                if (this.source.peekLine() == null) {
                    return false;
                }
                ArrayList<String> row = this.parseRow(this.source.readLine());
                this.values = new HashMap();
                if (this.columnNumbers.length == 0) {
                    int i = 0;
                    for (String string : row) {
                        this.values.put(this.columnNames[i++], string);
                    }
                } else {
                    int[] arr$ = this.columnNumbers;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Integer number = arr$[i$];
                        this.values.put(this.columnNames[number], row.get(number));
                    }
                }
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String preprocessExternalData(String string) {
            return string.replace("EMPTY", "NaN");
        }

        private ArrayList<String> parseRow(String row) throws MicroarrayException {
            ArrayList<String> result = new ArrayList<String>(this.settings.columns.size());
            row = this.preprocessExternalData(row);
            String[] cells = TableColumn.tokeniseRow(row);
            for (int i = 0; i < this.settings.columns.values().size(); ++i) {
                String cell = i < cells.length ? cells[i] : "";
                result.add(cell);
            }
            return result;
        }

        @Override
        public String[] getColumnNames() {
            String[] colunmNameSlice = new String[this.columnNumbers.length];
            for (int i = 0; i < this.columnNumbers.length; ++i) {
                colunmNameSlice[i] = this.columnNames[this.columnNumbers[i]];
            }
            return colunmNameSlice;
        }

        @Override
        public float getFloatValue(String columnName) {
            try {
                return new Float(this.values.get(columnName)).floatValue();
            }
            catch (NumberFormatException nfe) {
                return new Float(Float.NaN).floatValue();
            }
            catch (NullPointerException ne) {
                throw new IllegalArgumentException("column name " + columnName + " was not found");
            }
        }

        @Override
        public int getIntValue(String columnName) {
            return (int)this.getFloatValue(columnName);
        }

        @Override
        public String getStringValue(String columnName) {
            return this.values.get(columnName);
        }

        @Override
        public Object getValue(String columnName) {
            try {
                return new Float(this.values.get(columnName));
            }
            catch (NumberFormatException e) {
                return this.getStringValue(columnName);
            }
        }

        @Override
        public boolean hasColumn(String columnName) {
            for (String name : this.columnNames) {
                if (!name.equals(columnName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getCount() {
            return this.columnNames.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnIterator<T>
    implements Iterator<T> {
        private LookaheadLineReader source;
        private boolean headerParsed = false;
        private MatrixParseSettings settings;
        private int columnNumber;
        private boolean convertToFloats;

        public ColumnIterator(DataBean bean, MatrixParseSettings settings, int columnNumber, boolean convertToFloats) {
            try {
                this.source = new LookaheadLineReader(new BufferedReader(new InputStreamReader(bean.getContentByteStream())));
                this.settings = settings;
                this.columnNumber = columnNumber;
                this.convertToFloats = convertToFloats;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.source != null;
        }

        @Override
        public T next() {
            try {
                if (!this.headerParsed) {
                    if (this.settings.headerTerminator != null) {
                        TableColumn.parseAwayHeader(this.source, this.settings);
                    }
                    if (this.settings.hasColumnNames) {
                        this.source.readLine();
                    }
                    this.headerParsed = true;
                }
                ArrayList<T> row = this.parseRow(this.source.readLine());
                if (this.source.peekLine() == null || this.settings.footerStarter != null && this.source.peekLine().contains(this.settings.footerStarter) || this.headerParsed && "".equals(this.source.peekLine().trim())) {
                    this.source = null;
                }
                return row.get(this.columnNumber);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String preprocessExternalData(String string) {
            return string.replace("EMPTY", "NaN");
        }

        private ArrayList<T> parseRow(String row) throws MicroarrayException {
            ArrayList<Object> result = new ArrayList<Object>(this.settings.columns.size());
            row = this.preprocessExternalData(row);
            String[] cells = TableColumn.tokeniseRow(row);
            for (int i = 0; i < this.settings.columns.values().size(); ++i) {
                String cell = i < cells.length ? cells[i] : "";
                if (this.convertToFloats) {
                    try {
                        result.add(new Float(cell));
                    }
                    catch (NumberFormatException e) {
                        result.add(new Float(Float.NaN));
                    }
                    continue;
                }
                result.add(cell);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnIterable<T>
    implements Iterable<T> {
        private DataBean bean;
        private MatrixParseSettings settings;
        private int columnNumber;
        private boolean convertToFloats;

        public ColumnIterable(DataBean bean, MatrixParseSettings settings, int columnNumber, boolean convertToFloats) {
            this.bean = bean;
            this.settings = settings;
            this.columnNumber = columnNumber;
            this.convertToFloats = convertToFloats;
        }

        @Override
        public Iterator<T> iterator() {
            return new ColumnIterator(this.bean, this.settings, this.columnNumber, this.convertToFloats);
        }
    }

    private static class Column {
        String name;

        public Column(String name) {
            this.name = name;
        }
    }
}

