/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.bio;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.BasicFeature;
import fi.csc.microarray.databeans.features.CalculatingIterable;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureFactory;
import fi.csc.microarray.databeans.features.FeatureFactoryBase;

public class NormalisedExpressionFactory
extends FeatureFactoryBase {
    public Feature createFeature(String postfix, DataBean bean) {
        return new NormalisedExpression(bean, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NormalisedExpression
    extends BasicFeature {
        private static final String EXPRESSION_COLUMN = "/column/chip.microarray1.cel";
        private static final String RED_CHANNEL_INTENSITY = "/column/sample";
        private static final String RED_CHANNEL_BACKGROUND = "/column/samplebg";
        private static final String GREEN_CHANNEL_INTENSITY = "/column/control";
        private static final String GREEN_CHANNEL_BACKGROUND = "/column/controlbg";
        private static final String AFFY_INTENSITY = "/column/MEAN";

        public NormalisedExpression(DataBean bean, FeatureFactory factory) {
            super(bean, factory);
        }

        @Override
        public Iterable<Float> asFloats() throws MicroarrayException {
            if (this.getDataBean().fetchFeature(EXPRESSION_COLUMN).exists()) {
                return this.getDataBean().fetchFeature(EXPRESSION_COLUMN).asFloats();
            }
            Feature rciColumn = this.getDataBean().fetchFeature(RED_CHANNEL_INTENSITY);
            Feature rcbColumn = this.getDataBean().fetchFeature(RED_CHANNEL_BACKGROUND);
            Feature gciColumn = this.getDataBean().fetchFeature(GREEN_CHANNEL_INTENSITY);
            Feature gcbColumn = this.getDataBean().fetchFeature(GREEN_CHANNEL_BACKGROUND);
            if (rciColumn.exists() && rcbColumn.exists() && gciColumn.exists() && gcbColumn.exists()) {
                CalculatingIterable redIntensity = new CalculatingIterable(rciColumn.asFloats(), rcbColumn.asFloats(), CalculatingIterable.CalcOperation.SUBTRACT);
                CalculatingIterable greenIntensity = new CalculatingIterable(gciColumn.asFloats(), gcbColumn.asFloats(), CalculatingIterable.CalcOperation.SUBTRACT);
                return new CalculatingIterable(redIntensity, greenIntensity, CalculatingIterable.CalcOperation.SUBTRACT);
            }
            if (this.getDataBean().fetchFeature(AFFY_INTENSITY).exists()) {
                return this.getDataBean().fetchFeature(AFFY_INTENSITY).asFloats();
            }
            return null;
        }
    }
}

