/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.Projection;
import fi.csc.microarray.client.visualisation.methods.threed.Worker;
import java.util.LinkedList;

public class AutomatedMovement
extends Thread {
    private Projection projection;
    private Worker worker;
    private LinkedList<Task> taskQueue;
    private Object obj;
    RotationTask task;

    public AutomatedMovement(Projection projection, Worker worker) {
        this.projection = projection;
        this.worker = worker;
        this.taskQueue = new LinkedList();
        this.obj = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTranslationTask(double[] point, long time, double fps) {
        Object object = this.obj;
        synchronized (object) {
            this.taskQueue.addLast(new TranslationTask(point, time, fps));
            this.obj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRotationTask(double xRotation, double yRotation, double zRotation, long time, double fps) {
        Object object = this.obj;
        synchronized (object) {
            while (this.taskQueue.size() > 0) {
                this.taskQueue.remove();
            }
            this.taskQueue.addLast(new RotationTask(xRotation, yRotation, zRotation, time, fps));
            this.obj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RotationTask startKineticMove(double fps, double retardation) {
        Object object = this.obj;
        synchronized (object) {
            while (this.taskQueue.size() > 0) {
                this.taskQueue.remove();
            }
            this.task = new RotationTask(0.0, 0.0, 0.0, fps, retardation);
            this.taskQueue.addLast(this.task);
            this.obj.notify();
        }
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RotationTask restartKineticMove() {
        Object object = this.obj;
        synchronized (object) {
            while (this.taskQueue.size() > 0) {
                this.taskQueue.remove();
            }
            this.taskQueue.addLast(this.task);
            this.obj.notify();
        }
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Task task;
            Object object = this.obj;
            synchronized (object) {
                while (this.taskQueue.isEmpty()) {
                    try {
                        this.obj.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                task = this.taskQueue.poll();
                this.obj.notify();
            }
            task.doTask();
            task = null;
        }
    }

    public class RotationTask
    extends Task {
        double ticks;
        double timeIncrement;
        double xAngleInc;
        double yAngleInc;
        double zAngleInc;
        double retardation;

        public RotationTask(double xRotation, double yRotation, double zRotation, long time, double fps) {
            this.retardation = 1.0;
            this.ticks = (double)time / 1000.0 * fps;
            this.timeIncrement = 1000.0 / fps;
            this.xAngleInc = (xRotation - AutomatedMovement.this.projection.getXAxisRotation()) / this.ticks;
            this.yAngleInc = (yRotation - AutomatedMovement.this.projection.getYAxisRotation()) / this.ticks;
            this.zAngleInc = (zRotation - AutomatedMovement.this.projection.getZAxisRotation()) / this.ticks;
        }

        public RotationTask(double xAngleInc, double yAngleInc, double zAngleInc, double fps, double retardation) {
            this.retardation = 1.0;
            this.ticks = 9.223372036854776E18;
            this.timeIncrement = 1000.0 / fps;
            this.retardation = retardation;
            this.xAngleInc = xAngleInc;
            this.yAngleInc = yAngleInc;
            this.zAngleInc = zAngleInc;
        }

        public void setAngleIncs(double xAngleInc, double yAngleInc, double zAngleInc) {
            this.xAngleInc = xAngleInc;
            this.yAngleInc = yAngleInc;
            this.zAngleInc = zAngleInc;
        }

        public void stop() {
            this.ticks = -1.0;
        }

        public void doTask() {
            int i = 0;
            while ((double)i < this.ticks) {
                AutomatedMovement.this.projection.setXAxisRotation(AutomatedMovement.this.projection.getXAxisRotation() + this.xAngleInc);
                AutomatedMovement.this.projection.setYAxisRotation(AutomatedMovement.this.projection.getYAxisRotation() + this.yAngleInc);
                AutomatedMovement.this.projection.setZAxisRotation(AutomatedMovement.this.projection.getZAxisRotation() + this.zAngleInc);
                AutomatedMovement.this.worker.workRequest();
                this.xAngleInc *= this.retardation;
                this.yAngleInc *= this.retardation;
                this.zAngleInc *= this.retardation;
                try {
                    Thread.sleep((long)this.timeIncrement);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            this.ticks = 9.223372036854776E18;
        }
    }

    private class TranslationTask
    extends Task {
        private double[] point;
        private long time;
        private double fps;

        public TranslationTask(double[] point, long time, double fps) {
            this.point = point;
            this.time = time;
            this.fps = fps;
        }

        public void doTask() {
            double ticks = (double)this.time / 1000.0 * this.fps;
            double timeIncrement = 1000.0 / this.fps;
            double[] placeIncrement = new double[]{this.point[0] / ticks, this.point[1] / ticks, this.point[2] / ticks};
            int i = 0;
            while ((double)i < ticks) {
                AutomatedMovement.this.projection.setNewOrigin(placeIncrement);
                AutomatedMovement.this.worker.workRequest();
                try {
                    Thread.sleep((long)timeIncrement);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private class Task {
        private Task() {
        }

        public void doTask() {
        }
    }
}

