/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.data.selection.DataSelectionManager;
import fi.csc.microarray.client.data.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.dialog.RenameDialog;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.wizard.WizardPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class MicroarrayMenuBar
extends JMenuBar
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MicroarrayMenuBar.class);
    private SwingClientApplication application;
    private JMenu fileMenu = null;
    private JMenu importMenu = null;
    private JMenuItem directImportMenuItem = null;
    private JMenuItem importFromURLMenuItem = null;
    private JMenuItem importFromClipboardMenuItem = null;
    private JMenuItem refreshWorkflowsMenuItem = null;
    private JMenuItem addDirMenuItem = null;
    private JMenuItem exportMenuItem = null;
    private JMenuItem quitMenuItem = null;
    private JMenu editMenu = null;
    private JMenuItem renameMenuItem = null;
    private JMenuItem deleteMenuItem = null;
    private JMenu viewMenu = null;
    private JMenuItem restoreViewMenuItem = null;
    private JMenuItem minimiseLeftMenuItem = null;
    private JMenuItem minimiseOperations = null;
    private JMenu wizardMenu = null;
    private JMenu workflowsMenu = null;
    private JMenuItem wizardMenuItem = null;
    private JMenu helpInfoMenu = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem contentMenuItem;
    private JMenuItem startedMenuItem;
    private JMenuItem saveWorkflowMenuItem;
    private JMenuItem saveSnapshotMenuItem;
    private JMenu runWorkflowMenu;
    private JMenuItem loadSnapshotMenuItem;
    private JMenuItem taskListMenuItem;

    public MicroarrayMenuBar(SwingClientApplication application) {
        this.application = application;
        this.add(this.getFileMenu());
        this.add(this.getEditMenu());
        this.add(this.getViewMenu());
        this.add(this.getWizardMenu());
        this.add(this.getWorkflowsMenu());
        this.add(this.getHelpInfoMenu());
        application.addPropertyChangeListener(this);
    }

    public void updateMenuStatus() {
        logger.debug("updating menubar when selected is " + this.application.getSelectionManager().getSelectedItem());
        DataSelectionManager selectionManager = this.application.getSelectionManager();
        List<String> workflows = this.application.getWorkflows();
        DataBean selectedDataBean = selectionManager.getSelectedDataBean();
        boolean somethingSelected = selectionManager.getSelectedItem() != null;
        boolean normalisedDataSelected = false;
        if (selectedDataBean != null) {
            normalisedDataSelected = ChipsterInputTypes.GENE_EXPRS.isTypeOf(selectedDataBean);
        }
        this.runWorkflowMenu.removeAll();
        this.runWorkflowMenu.setEnabled(normalisedDataSelected && workflows.size() > 0);
        if (this.runWorkflowMenu.isEnabled()) {
            for (String workflow : workflows) {
                this.runWorkflowMenu.add(this.createRunWorkflowMenuItem(workflow));
            }
        }
        this.saveWorkflowMenuItem.setEnabled(normalisedDataSelected);
        this.exportMenuItem.setEnabled(somethingSelected);
        this.renameMenuItem.setEnabled(somethingSelected);
        this.deleteMenuItem.setEnabled(somethingSelected);
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getDirectImportMenuItem());
            this.fileMenu.add(this.getAddDirMenuItem());
            this.fileMenu.add(this.getImportMenu());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExportMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getLoadSnapshotMenuItem());
            this.fileMenu.add(this.getSaveSnapshotMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getQuitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getImportMenu() {
        if (this.importMenu == null) {
            this.importMenu = new JMenu();
            this.importMenu.setText("Import from");
            this.importMenu.add(this.getImportFromURLMenuItem());
            this.importMenu.add(this.getImportFromClipboardMenuItem());
        }
        return this.importMenu;
    }

    private JMenuItem getDirectImportMenuItem() {
        if (this.directImportMenuItem == null) {
            this.directImportMenuItem = new JMenuItem();
            this.directImportMenuItem.setText("Import files...");
            this.directImportMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openFileImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.directImportMenuItem;
    }

    private JMenuItem getImportFromURLMenuItem() {
        if (this.importFromURLMenuItem == null) {
            this.importFromURLMenuItem = new JMenuItem();
            this.importFromURLMenuItem.setText("URL...");
            this.importFromURLMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openURLImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.importFromURLMenuItem;
    }

    private JMenuItem getRefreshWorkflowsMenuItem() {
        if (this.refreshWorkflowsMenuItem == null) {
            this.refreshWorkflowsMenuItem = new JMenuItem();
            this.refreshWorkflowsMenuItem.setText("Reload workflows from disk");
            this.refreshWorkflowsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.updateMenuStatus();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.refreshWorkflowsMenuItem;
    }

    private JMenuItem getImportFromClipboardMenuItem() {
        if (this.importFromClipboardMenuItem == null) {
            this.importFromClipboardMenuItem = new JMenuItem();
            this.importFromClipboardMenuItem.setText("clipboard...");
            this.importFromClipboardMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.openClipboardImport();
                    }
                    catch (Exception me) {
                        MicroarrayMenuBar.this.application.reportException(me);
                    }
                }
            });
        }
        return this.importFromClipboardMenuItem;
    }

    private JMenuItem getExportMenuItem() {
        if (this.exportMenuItem == null) {
            this.exportMenuItem = new JMenuItem();
            this.exportMenuItem.setText("Export dataset or folder...");
            this.exportMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.exportSelectedItem();
                }
            });
        }
        return this.exportMenuItem;
    }

    private JMenuItem getQuitMenuItem() {
        if (this.quitMenuItem == null) {
            this.quitMenuItem = new JMenuItem();
            this.quitMenuItem.setText("Quit");
            this.quitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.quit();
                }
            });
        }
        return this.quitMenuItem;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText("Edit");
            this.editMenu.add(this.getRenameMenuItem());
            this.editMenu.add(this.getDeleteMenuItem());
        }
        return this.editMenu;
    }

    private JMenuItem getRenameMenuItem() {
        if (this.renameMenuItem == null) {
            this.renameMenuItem = new JMenuItem();
            this.renameMenuItem.setText("Rename selected item...");
            this.renameMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new RenameDialog(MicroarrayMenuBar.this.application, MicroarrayMenuBar.this.application.getSelectionManager().getSelectedItem());
                }
            });
        }
        return this.renameMenuItem;
    }

    private JMenuItem getDeleteMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem();
            this.deleteMenuItem.setText("Delete selected item");
            this.deleteMenuItem.setIcon(VisualConstants.DELETE_MENUICON);
            this.deleteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.deleteData(MicroarrayMenuBar.this.application.getSelectionManager().getSelectedItem(), true);
                }
            });
        }
        return this.deleteMenuItem;
    }

    private JMenu getWizardMenu() {
        if (this.wizardMenu == null) {
            this.wizardMenu = new JMenu();
            this.wizardMenu.setText("Wizard");
            this.wizardMenu.add(this.getWizardMenuItem());
        }
        return this.wizardMenu;
    }

    private JMenu getWorkflowsMenu() {
        if (this.workflowsMenu == null) {
            this.workflowsMenu = new JMenu();
            this.workflowsMenu.setText("Workflow");
            this.workflowsMenu.add(this.getSaveWorkflowMenuItem());
            this.workflowsMenu.add(this.getRunWorkflowMenu());
            this.workflowsMenu.add(this.getRefreshWorkflowsMenuItem());
        }
        return this.workflowsMenu;
    }

    private JMenuItem getTaskListMenuItem() {
        if (this.taskListMenuItem == null) {
            this.taskListMenuItem = new JMenuItem();
            this.taskListMenuItem.setText("Tasks...");
            this.taskListMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.flipTaskListVisibility(false);
                }
            });
        }
        return this.taskListMenuItem;
    }

    private JMenuItem getSaveWorkflowMenuItem() {
        if (this.saveWorkflowMenuItem == null) {
            this.saveWorkflowMenuItem = new JMenuItem();
            this.saveWorkflowMenuItem.setText("Save starting from selected");
            this.saveWorkflowMenuItem.setEnabled(false);
            this.saveWorkflowMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.saveWorkflow();
                }
            });
        }
        return this.saveWorkflowMenuItem;
    }

    private JMenu getRunWorkflowMenu() {
        if (this.runWorkflowMenu == null) {
            this.runWorkflowMenu = new JMenu();
            this.runWorkflowMenu.setText("Run...");
        }
        return this.runWorkflowMenu;
    }

    private JMenuItem createRunWorkflowMenuItem(final String scriptName) {
        JMenuItem runWorkflowMenuItem = new JMenuItem();
        runWorkflowMenuItem.setText(scriptName);
        runWorkflowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MicroarrayMenuBar.this.application.runWorkflow(scriptName);
            }
        });
        return runWorkflowMenuItem;
    }

    private JMenuItem getWizardMenuItem() {
        if (this.wizardMenuItem == null) {
            this.wizardMenuItem = new JMenuItem();
            this.wizardMenuItem.setText("Affymetrix");
            this.wizardMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WizardPlugin wiz = new WizardPlugin(MicroarrayMenuBar.this.application);
                    wiz.show();
                }
            });
        }
        return this.wizardMenuItem;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText("View");
            this.viewMenu.add(this.getRestoreViewMenuItem());
            this.viewMenu.add(this.getMinimiseLeftMenuItem());
            this.viewMenu.add(this.getMinimiseOperations());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getTaskListMenuItem());
        }
        return this.viewMenu;
    }

    private JMenuItem getRestoreViewMenuItem() {
        if (this.restoreViewMenuItem == null) {
            this.restoreViewMenuItem = new JMenuItem();
            this.restoreViewMenuItem.setText("Restore default");
            this.restoreViewMenuItem.setIcon(VisualConstants.DEFAULT_VIEW_MENUICON);
            this.restoreViewMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.restoreDefaultView();
                }
            });
        }
        return this.restoreViewMenuItem;
    }

    private JMenu getHelpInfoMenu() {
        if (this.helpInfoMenu == null) {
            this.helpInfoMenu = new JMenu();
            this.helpInfoMenu.setText("Help");
            this.helpInfoMenu.add(this.getStartedMenuItem());
            this.helpInfoMenu.add(this.getContentMenuItem());
            this.helpInfoMenu.add(this.getAboutMenuItem());
        }
        return this.helpInfoMenu;
    }

    private JMenuItem getContentMenuItem() {
        if (this.contentMenuItem == null) {
            this.contentMenuItem = new JMenuItem();
            this.contentMenuItem.setText("Contents");
            this.contentMenuItem.setIcon(VisualConstants.HELP_MENUICON);
            this.contentMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp("chipster-manual/index.html");
                }
            });
        }
        return this.contentMenuItem;
    }

    private JMenuItem getStartedMenuItem() {
        if (this.startedMenuItem == null) {
            this.startedMenuItem = new JMenuItem();
            this.startedMenuItem.setText("Getting started");
            this.startedMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp("chipster-manual/basic-functionality.html");
                }
            });
        }
        return this.startedMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.viewHelp("chipster-manual/about.html");
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getMinimiseLeftMenuItem() {
        if (this.minimiseLeftMenuItem == null) {
            this.minimiseLeftMenuItem = new JMenuItem();
            this.minimiseLeftMenuItem.setText("Minimise left side");
            this.minimiseLeftMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.minimiseLeftSide();
                }
            });
        }
        return this.minimiseLeftMenuItem;
    }

    private JMenuItem getMinimiseOperations() {
        if (this.minimiseOperations == null) {
            this.minimiseOperations = new JMenuItem();
            this.minimiseOperations.setText("Minimise analysis tool panel");
            this.minimiseOperations.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.minimiseOperations();
                }
            });
        }
        return this.minimiseOperations;
    }

    private JMenuItem getLoadSnapshotMenuItem() {
        if (this.loadSnapshotMenuItem == null) {
            this.loadSnapshotMenuItem = new JMenuItem();
            this.loadSnapshotMenuItem.setText("Load workspace");
            this.loadSnapshotMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.loadSnapshot(ClientApplication.SNAPSHOT_DIR);
                    }
                    catch (Exception ioe) {
                        MicroarrayMenuBar.this.application.reportException(ioe);
                    }
                }
            });
        }
        return this.loadSnapshotMenuItem;
    }

    private JMenuItem getSaveSnapshotMenuItem() {
        if (this.saveSnapshotMenuItem == null) {
            this.saveSnapshotMenuItem = new JMenuItem();
            this.saveSnapshotMenuItem.setText("Save workspace");
            this.saveSnapshotMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MicroarrayMenuBar.this.application.setBusyMode(true);
                        int dataCount = Session.getSession().getDataManager().saveSnapshot(ClientApplication.SNAPSHOT_DIR);
                        MicroarrayMenuBar.this.application.setBusyMode(false);
                        MicroarrayMenuBar.this.updateMenuStatus();
                        MicroarrayMenuBar.this.application.setUnsavedChanges(false);
                        MicroarrayMenuBar.this.application.showDialog("Workspace saved.", "At the moment, you can only save and load one workspace. In the future versions of Chipster, saving and loading multiple workspaces will be possible.\n\nIf you need to transfer a workspace to another computer, see the details for the location of the saved workspace, and then copy the workspace folder to the corresponding location on the other computer.", "Workspace folder: " + ClientApplication.SNAPSHOT_DIR + "\n" + "Datasets saved: " + dataCount, DialogInfo.Severity.INFO, false);
                    }
                    catch (Exception exp) {
                        MicroarrayMenuBar.this.application.setBusyMode(false);
                        MicroarrayMenuBar.this.application.showErrorDialog("Saving workspace failed.", exp);
                    }
                }
            });
        }
        return this.saveSnapshotMenuItem;
    }

    private JMenuItem getAddDirMenuItem() {
        if (this.addDirMenuItem == null) {
            this.addDirMenuItem = new JMenuItem();
            this.addDirMenuItem.setText("Import folder...");
            this.addDirMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MicroarrayMenuBar.this.application.openDirectoryImportDialog();
                }
            });
        }
        return this.addDirMenuItem;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof DatasetChoiceEvent) {
            this.updateMenuStatus();
        }
    }
}

