/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.Platform;
import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.JComponentTester;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class JTextComponentTester
extends JComponentTester {
    public void actionEnterText(Component c, String text) {
        this.scrollToVisible(c, 0);
        this.actionActionMap(c, "select-all");
        if (text == null || "".equals(text)) {
            if (!"".equals(((JTextComponent)c).getText())) {
                this.actionActionMap(c, "delete-previous");
            }
        } else {
            this.actionKeyString(c, text);
        }
    }

    public void actionClick(Component tc, int index) {
        Point where = this.scrollToVisible(tc, index);
        this.actionClick(tc, where.x, where.y);
    }

    public void actionSetCaretPosition(Component tc, int index) {
        this.actionClick(tc, index);
    }

    protected Point scrollToVisible(Component c, int index) {
        JTextComponent tc = (JTextComponent)c;
        try {
            Rectangle visible = tc.getVisibleRect();
            Rectangle rect = tc.modelToView(index);
            Log.debug("visible=" + visible + ", index=" + index + " is at " + rect);
            if (rect == null) {
                String msg = Strings.get("tester.zero_size");
                throw new ActionFailedException(msg);
            }
            if (!visible.contains(rect.x, rect.y)) {
                this.scrollRectToVisible(tc, rect);
                visible = tc.getVisibleRect();
                rect = tc.modelToView(index);
                Log.debug("visible=" + visible + " caret=" + rect);
                if (!visible.contains(rect.x, rect.y)) {
                    String msg = Strings.get("tester.JComponent.not_visible", new Object[]{new Integer(rect.x), new Integer(rect.y), tc});
                    throw new ActionFailedException(msg);
                }
            }
            return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
        }
        catch (BadLocationException ble) {
            String msg = Strings.get("tester.JTextComponent.bad_location", new Object[]{ble.getMessage(), new Integer(index), tc.getText()});
            throw new ActionFailedException(msg);
        }
    }

    protected void scrollRectToVisible(JComponent c, Rectangle rect) {
        super.scrollRectToVisible(c, rect);
        if (!this.isVisible(c, rect) && c instanceof JTextField) {
            Container parent;
            int dx = c.getX();
            int dy = c.getY();
            for (parent = c.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
                Rectangle bounds = parent.getBounds();
                dx += bounds.x;
                dy += bounds.y;
            }
            if (parent != null && !(parent instanceof CellRendererPane)) {
                rect.x += dx;
                rect.y += dy;
                super.scrollRectToVisible((JComponent)parent, rect);
                rect.x -= dx;
                rect.y -= dy;
            }
        }
    }

    protected void startSelection(Component comp, int index) {
        final JTextComponent tc = (JTextComponent)comp;
        if (tc.getSelectionStart() != tc.getSelectionEnd()) {
            this.invokeAndWait(new Runnable(){

                public void run() {
                    tc.setCaretPosition(0);
                    tc.moveCaretPosition(0);
                }
            });
        }
        Point where = this.scrollToVisible(comp, index);
        this.mousePress(comp, where.x, where.y);
    }

    protected void endSelection(Component comp, int index) {
        Point where = this.scrollToVisible(comp, index);
        this.mouseMove(comp, where.x, where.y);
        if (Platform.isOSX()) {
            this.delay(75);
        }
        this.mouseRelease();
    }

    public void actionStartSelection(Component comp, int index) {
        this.startSelection(comp, index);
        this.waitForIdle();
    }

    public void actionEndSelection(Component comp, int index) {
        this.endSelection(comp, index);
        this.waitForIdle();
    }

    public void actionSelect(Component comp, int start, int end) {
        this.actionSelectText(comp, start, end);
    }

    public void actionSelectText(Component comp, int start, int end) {
        this.actionStartSelection(comp, start);
        this.actionEndSelection(comp, end);
        JTextComponent tc = (JTextComponent)comp;
        if (tc.getSelectionStart() != Math.min(start, end) || tc.getSelectionEnd() != Math.max(start, end)) {
            String msg = Strings.get("tester.JTextComponent.selection_failed", new Object[]{new Integer(start), new Integer(end), new Integer(tc.getSelectionStart()), new Integer(tc.getSelectionEnd())});
            throw new ActionFailedException(msg);
        }
    }
}

