/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import javax.swing.ImageIcon;

public class ImageComparator
implements Comparator {
    private static Image convertToImage(Object obj) throws IOException {
        if (obj instanceof String) {
            obj = new File((String)obj);
        }
        if (obj instanceof File) {
            obj = new ImageIcon(((File)obj).toURL()).getImage();
        }
        if (obj instanceof Image) {
            return (Image)obj;
        }
        return null;
    }

    public static void writeJPEG(File file, BufferedImage img) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        JPEGImageEncoder ie = JPEGCodec.createJPEGEncoder((OutputStream)os);
        JPEGEncodeParam param = ie.getDefaultJPEGEncodeParam(img);
        param.setQuality(1.0f, false);
        ie.setJPEGEncodeParam(param);
        ie.encode(img);
        os.close();
    }

    public int compare(Object obj1, Object obj2) {
        try {
            obj1 = ImageComparator.convertToImage(obj1);
        }
        catch (IOException io) {
            throw new IllegalArgumentException("Object is not convertable to an Image: " + obj1);
        }
        try {
            obj2 = ImageComparator.convertToImage(obj2);
        }
        catch (IOException io) {
            throw new IllegalArgumentException("Object is not convertable to an Image: " + obj2);
        }
        Log.debug("Comparing " + obj1 + " and " + obj2);
        Image image1 = (Image)obj1;
        int w = image1.getWidth(null);
        int h = image1.getHeight(null);
        Image image2 = (Image)obj2;
        int w2 = image2.getWidth(null);
        int h2 = image2.getHeight(null);
        if (w * h != w2 * h2) {
            return w * h - w2 * h2;
        }
        int[] pixels1 = new int[w * h];
        int[] pixels2 = new int[w * h];
        PixelGrabber pg1 = new PixelGrabber(image1, 0, 0, w, h, pixels1, 0, w);
        PixelGrabber pg2 = new PixelGrabber(image2, 0, 0, w, h, pixels2, 0, w);
        try {
            pg1.grabPixels();
            pg2.grabPixels();
            for (int i = 0; i < w * h; ++i) {
                if (pixels1[i] == pixels2[i]) continue;
                return pixels1[i] - pixels2[i];
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(this.getClass());
    }
}

