/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.BugReport;
import abbot.Log;
import abbot.WaitTimedOutError;
import abbot.finder.AWTHierarchy;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentNotFoundException;
import abbot.finder.ComponentSearchException;
import abbot.finder.Hierarchy;
import abbot.finder.MultipleComponentsFoundException;
import abbot.finder.matchers.WindowMatcher;
import abbot.i18n.Strings;
import abbot.script.ComponentReference;
import abbot.script.Condition;
import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.ImageComparator;
import abbot.tester.Robot;
import abbot.util.AWT;
import abbot.util.Bugs;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.event.AWTEventListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.swing.text.JTextComponent;

public class ComponentTester
extends Robot {
    protected static Set IGNORED_METHODS = new HashSet();
    private static HashMap testers;
    private static final String[] tagMethods;
    private Method[] cachedMethods = null;
    private Method[] cachedActions = null;
    private Method[] cachedComponentActions = null;
    private Method[] cachedPropertyMethods = null;
    private Method[] cachedAssertMethods = null;
    private Method[] cachedComponentAssertMethods = null;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;

    public static void setTester(Class forClass, ComponentTester tester) {
        testers.put(forClass.getName(), tester);
    }

    public static ComponentTester getTester(Component comp) {
        return comp != null ? ComponentTester.getTester(comp.getClass()) : ComponentTester.getTester(class$java$awt$Component == null ? (class$java$awt$Component = ComponentTester.class$("java.awt.Component")) : class$java$awt$Component);
    }

    public static ComponentTester getTester(Class componentClass) {
        String className = componentClass.getName();
        ComponentTester tester = (ComponentTester)testers.get(className);
        if (tester == null) {
            if (!(class$java$awt$Component == null ? (class$java$awt$Component = ComponentTester.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(componentClass)) {
                String msg = "Class " + className + " is not derived from java.awt.Component";
                throw new IllegalArgumentException(msg);
            }
            Log.debug("Looking up tester for " + componentClass);
            String testerName = ComponentTester.simpleClassName(componentClass) + "Tester";
            Package pkg = (class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = ComponentTester.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).getPackage();
            String pkgName = "";
            if (pkg == null) {
                Log.warn("ComponentTester.class has null package; the class loader is likely flawed: " + (class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = ComponentTester.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).getClassLoader() + ", " + Thread.currentThread().getContextClassLoader(), 0);
                pkgName = "abbot.tester";
            } else {
                pkgName = pkg.getName();
            }
            if (className.startsWith("javax.swing.") || className.startsWith("java.awt.")) {
                tester = ComponentTester.findTester(pkgName + "." + testerName, componentClass);
            }
            if (tester == null && (tester = ComponentTester.findTester(pkgName + ".extensions." + testerName, componentClass)) == null) {
                tester = ComponentTester.getTester(componentClass.getSuperclass());
            }
            if (tester != null && !tester.isExtension()) {
                testers.put(componentClass.getName(), tester);
            }
        }
        return tester;
    }

    public final boolean isExtension() {
        return this.getClass().getName().startsWith("abbot.tester.extensions");
    }

    private static Class resolveClass(String testerName, Class componentClass) throws ClassNotFoundException {
        Class<?> cls = testerName.startsWith("abbot.tester.extensions") ? Class.forName(testerName, true, componentClass.getClassLoader()) : Class.forName(testerName);
        Log.debug("Loaded class " + testerName + " with " + cls.getClassLoader());
        return cls;
    }

    private static ComponentTester findTester(String testerName, Class componentClass) {
        ComponentTester tester = null;
        Class testerClass = null;
        try {
            testerClass = ComponentTester.resolveClass(testerName, componentClass);
            tester = (ComponentTester)testerClass.newInstance();
        }
        catch (InstantiationException ie) {
            Log.warn(ie);
        }
        catch (IllegalAccessException iae) {
            Log.warn(iae);
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (ClassCastException cce) {
            throw new BugReport("Class loader conflict: environment " + (class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = ComponentTester.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).getClassLoader() + " vs. " + testerClass.getClassLoader());
        }
        return tester;
    }

    protected String deriveAccessibleTag(AccessibleContext context) {
        String tag = null;
        if (context != null) {
            AccessibleIcon[] icons;
            if (context.getAccessibleName() != null) {
                tag = context.getAccessibleName();
            }
            if ((tag == null || "".equals(tag)) && context.getAccessibleIcon() != null && context.getAccessibleIcon().length > 0 && (tag = (icons = context.getAccessibleIcon())[0].getAccessibleIconDescription()) != null) {
                tag = tag.substring(tag.lastIndexOf("/") + 1);
                tag = tag.substring(tag.lastIndexOf("\\") + 1);
            }
        }
        return tag;
    }

    public static String getTag(Component comp) {
        return ComponentTester.getTester(comp.getClass()).deriveTag(comp);
    }

    protected boolean isCustom(Class c) {
        return !c.getName().startsWith("javax.swing.") && !c.getName().startsWith("java.awt.");
    }

    public String deriveTag(Component comp) {
        String ptag;
        Container parent;
        if (this.isCustom(comp.getClass())) {
            return null;
        }
        String tag = null;
        for (int i = 0; i < tagMethods.length; ++i) {
            if ((comp instanceof JTextComponent || comp instanceof TextComponent) && "getText".equals(tagMethods[i])) continue;
            try {
                Method m = comp.getClass().getMethod(tagMethods[i], null);
                String tmp = (String)m.invoke((Object)comp, null);
                if (tmp == null || "".equals(tmp)) continue;
                tag = tmp;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!(tag != null && !"".equals(tag) || (parent = comp.getParent()) == null || (ptag = ComponentTester.getTag(parent)) == null || "".equals(tag) || ptag.endsWith(" Root Pane"))) {
            StringBuffer buf = new StringBuffer(ptag);
            int under = ptag.indexOf(" under ");
            if (under != -1) {
                buf = buf.delete(0, under + 7);
            }
            buf.insert(0, " under ");
            buf.insert(0, ComponentTester.simpleClassName(comp.getClass()));
            tag = buf.toString();
        }
        return tag;
    }

    public void actionWaitForIdle() {
        this.waitForIdle();
    }

    public void actionDelay(int ms) {
        this.delay(ms);
    }

    public void actionSelectAWTMenuItemByLabel(Frame menuFrame, String path) {
        this.actionSelectAWTMenuItem(menuFrame, path);
    }

    public void actionSelectAWTMenuItem(Frame menuFrame, String path) {
        AWTMenuListener listener = new AWTMenuListener();
        new WeakAWTEventListener(listener, 128L);
        this.selectAWTMenuItem(menuFrame, path);
        long start = System.currentTimeMillis();
        while (!listener.eventFired) {
            if (System.currentTimeMillis() - start > (long)defaultDelay) {
                throw new ActionFailedException("Menu item '" + path + "' failed to fire");
            }
            this.sleep();
        }
        this.waitForIdle();
    }

    public void actionSelectAWTPopupMenuItemByLabel(Component invoker, String path) {
        this.actionSelectAWTPopupMenuItem(invoker, path);
    }

    public void actionSelectAWTPopupMenuItem(Component invoker, String path) {
        AWTMenuListener listener = new AWTMenuListener();
        new WeakAWTEventListener(listener, 128L);
        this.selectAWTPopupMenuItem(invoker, path);
        long start = System.currentTimeMillis();
        while (!listener.eventFired) {
            if (System.currentTimeMillis() - start > (long)defaultDelay) {
                throw new ActionFailedException("Menu item '" + path + "' failed to fire");
            }
            this.sleep();
        }
        this.waitForIdle();
    }

    public void actionSelectMenuItem(Component item) {
        Log.debug("Attempting to select menu item " + ComponentTester.toString(item));
        this.selectMenuItem(item);
        this.waitForIdle();
    }

    public void actionSelectMenuItem(Component sameWindow, String path) {
        Log.debug("Attempting to select menu item '" + path + "'");
        this.selectMenuItem(sameWindow, path);
        this.waitForIdle();
    }

    public void actionSelectPopupMenuItem(Component invoker, String path) {
        this.actionSelectPopupMenuItem(invoker, invoker.getWidth() / 2, invoker.getHeight() / 2, path);
    }

    public void actionSelectPopupMenuItem(Component invoker, ComponentLocation loc, String path) {
        this.selectPopupMenuItem(invoker, loc, path);
        this.waitForIdle();
    }

    public void actionSelectPopupMenuItem(Component invoker, int x, int y, String path) {
        this.actionSelectPopupMenuItem(invoker, new ComponentLocation(new Point(x, y)), path);
    }

    public void actionShowPopupMenu(Component invoker) {
        this.actionShowPopupMenu(invoker, new ComponentLocation());
    }

    public void actionShowPopupMenu(Component invoker, ComponentLocation loc) {
        Point where = loc.getPoint(invoker);
        this.showPopupMenu(invoker, where.x, where.y);
    }

    public void actionShowPopupMenu(Component invoker, int x, int y) {
        this.showPopupMenu(invoker, x, y);
    }

    public void actionClick(Component comp) {
        this.actionClick(comp, new ComponentLocation());
    }

    public void actionClick(Component c, ComponentLocation loc) {
        this.actionClick(c, loc, 16);
    }

    public void actionClick(Component c, ComponentLocation loc, int buttons) {
        this.actionClick(c, loc, buttons, 1);
    }

    public void actionClick(Component c, ComponentLocation loc, int buttons, int count) {
        Point where = loc.getPoint(c);
        this.click(c, where.x, where.y, buttons, count);
        this.waitForIdle();
    }

    public void actionClick(Component comp, int x, int y) {
        this.actionClick(comp, new ComponentLocation(new Point(x, y)));
    }

    public void actionClick(Component comp, int x, int y, int buttons) {
        this.actionClick(comp, x, y, buttons, 1);
    }

    public void actionClick(Component comp, int x, int y, int buttons, int count) {
        this.actionClick(comp, new ComponentLocation(new Point(x, y)), buttons, count);
    }

    public void actionKeyPress(Component comp, int keyCode) {
        this.actionFocus(comp);
        this.actionKeyPress(keyCode);
    }

    public void actionKeyPress(int keyCode) {
        this.keyPress(keyCode);
        this.waitForIdle();
    }

    public void actionKeyRelease(Component comp, int keyCode) {
        this.actionFocus(comp);
        this.actionKeyRelease(keyCode);
    }

    public void actionKeyRelease(int keyCode) {
        this.keyRelease(keyCode);
        this.waitForIdle();
    }

    public void actionSetModifiers(int mask, boolean pressed) {
        this.setModifiers(mask, pressed);
        this.waitForIdle();
    }

    public void actionKeyStroke(Component c, int keyCode) {
        this.actionFocus(c);
        this.actionKeyStroke(keyCode, 0);
    }

    public void actionKeyStroke(int keyCode) {
        this.actionKeyStroke(keyCode, 0);
    }

    public void actionKeyStroke(Component c, int keyCode, int modifiers) {
        this.actionFocus(c);
        this.actionKeyStroke(keyCode, modifiers);
    }

    public void actionKeyStroke(int keyCode, int modifiers) {
        if (Bugs.hasKeyStrokeGenerationBug()) {
            int oldDelay = ComponentTester.getAutoDelay();
            ComponentTester.setAutoDelay(50);
            this.key(keyCode, modifiers);
            ComponentTester.setAutoDelay(oldDelay);
            this.delay(100);
        } else {
            this.key(keyCode, modifiers);
        }
        this.waitForIdle();
    }

    public void actionKeyString(Component c, String string) {
        this.actionFocus(c);
        this.actionKeyString(string);
    }

    public void actionKeyString(String string) {
        this.keyString(string);
        if (Bugs.hasKeyStrokeGenerationBug()) {
            this.delay(100);
        }
        this.waitForIdle();
    }

    public void actionFocus(Component comp) {
        this.focus(comp, true);
    }

    public void actionMouseMove(Component comp, ComponentLocation loc) {
        Point where = loc.getPoint(comp);
        this.mouseMove(comp, where.x, where.y);
        this.waitForIdle();
    }

    public void actionMousePress(Component comp, ComponentLocation loc) {
        this.actionMousePress(comp, loc, 16);
    }

    public void actionMousePress(Component comp, ComponentLocation loc, int mask) {
        Point where = loc.getPoint(comp);
        this.mousePress(comp, where.x, where.y, mask);
        this.waitForIdle();
    }

    public void actionMouseRelease() {
        this.mouseRelease();
        this.waitForIdle();
    }

    public void actionDrag(Component dragSource, ComponentLocation loc) {
        this.actionDrag(dragSource, loc, "BUTTON1_MASK");
    }

    public void actionDrag(Component dragSource) {
        this.actionDrag(dragSource, new ComponentLocation());
    }

    public void actionDrag(Component dragSource, ComponentLocation loc, String buttons) {
        this.actionDrag(dragSource, loc, AWT.getModifiers(buttons));
    }

    public void actionDrag(Component dragSource, ComponentLocation loc, int buttons) {
        Point where = loc.getPoint(dragSource);
        this.drag(dragSource, where.x, where.y, buttons);
        this.waitForIdle();
    }

    public void actionDrag(Component dragSource, int sx, int sy) {
        this.actionDrag(dragSource, new ComponentLocation(new Point(sx, sy)));
    }

    public void actionDrag(Component dragSource, int sx, int sy, String buttons) {
        this.actionDrag(dragSource, new ComponentLocation(new Point(sx, sy)), buttons);
    }

    public void actionDragOver(Component target) {
        this.actionDragOver(target, new ComponentLocation());
    }

    public void actionDragOver(Component target, ComponentLocation where) {
        Point loc = where.getPoint(target);
        this.dragOver(target, loc.x, loc.y);
        this.waitForIdle();
    }

    public void actionDrop(Component dropTarget) {
        this.actionDrop(dropTarget, new ComponentLocation());
    }

    public void actionDrop(Component dropTarget, ComponentLocation loc) {
        Point where = loc.getPoint(dropTarget);
        this.drop(dropTarget, where.x, where.y);
        this.waitForIdle();
    }

    public void actionDrop(Component dropTarget, int x, int y) {
        this.drop(dropTarget, x, y);
        this.waitForIdle();
    }

    public boolean assertImage(Component comp, File fileImage, boolean ignoreBorder) {
        BufferedImage img = this.capture(comp, ignoreBorder);
        return new ImageComparator().compare(img, fileImage) == 0;
    }

    public boolean assertFrameShowing(Hierarchy h, String id) {
        try {
            BasicFinder finder = new BasicFinder(h);
            return finder.find(new WindowMatcher(id, true)) != null;
        }
        catch (ComponentNotFoundException e) {
            return false;
        }
        catch (MultipleComponentsFoundException m) {
            return true;
        }
    }

    public boolean assertFrameShowing(String id) {
        return this.assertFrameShowing(AWTHierarchy.getDefault(), id);
    }

    public void waitForFrameShowing(final Hierarchy h, final String identifier) {
        this.wait(new Condition(){

            public boolean test() {
                return ComponentTester.this.assertFrameShowing(h, identifier);
            }

            public String toString() {
                return Strings.get("tester.Component.show_wait", new Object[]{identifier});
            }
        }, (long)componentDelay);
    }

    public void waitForFrameShowing(String identifier) {
        this.waitForFrameShowing(AWTHierarchy.getDefault(), identifier);
    }

    public boolean assertComponentShowing(ComponentReference ref) {
        try {
            Component c = ref.getComponent();
            return this.isReadyForInput(c);
        }
        catch (ComponentSearchException e) {
            return false;
        }
    }

    public void waitForComponentShowing(final ComponentReference ref) {
        this.wait(new Condition(){

            public boolean test() {
                return ComponentTester.this.assertComponentShowing(ref);
            }

            public String toString() {
                return Strings.get("tester.Component.show_wait", new Object[]{ref});
            }
        }, (long)componentDelay);
    }

    private Method[] getMethods(String prefix, Class returnType, boolean componentArgument) {
        if (this.cachedMethods == null) {
            this.cachedMethods = this.getClass().getMethods();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        HashSet<String> names = new HashSet<String>(IGNORED_METHODS);
        Method[] mlist = this.cachedMethods;
        for (int i = 0; i < mlist.length; ++i) {
            String name = mlist[i].getName();
            if (names.contains(name) || !name.startsWith(prefix)) continue;
            Class<?>[] params = mlist[i].getParameterTypes();
            if (returnType != null && !returnType.equals(mlist[i].getReturnType()) || (params.length != 0 || componentArgument) && (params.length <= 0 || (class$java$awt$Component == null ? ComponentTester.class$("java.awt.Component") : class$java$awt$Component).isAssignableFrom(params[0]) != componentArgument)) continue;
            methods.add(mlist[i]);
            names.add(name);
        }
        return methods.toArray(new Method[methods.size()]);
    }

    public Method[] getActions() {
        if (this.cachedActions == null) {
            this.cachedActions = this.getMethods("action", Void.TYPE, false);
        }
        return this.cachedActions;
    }

    public Method[] getComponentActions() {
        if (this.cachedComponentActions == null) {
            this.cachedComponentActions = this.getMethods("action", Void.TYPE, true);
        }
        return this.cachedComponentActions;
    }

    public Method[] getPropertyMethods() {
        if (this.cachedPropertyMethods == null) {
            ArrayList<Method> all = new ArrayList<Method>();
            all.addAll(Arrays.asList(this.getMethods("is", Boolean.TYPE, true)));
            all.addAll(Arrays.asList(this.getMethods("has", Boolean.TYPE, true)));
            all.addAll(Arrays.asList(this.getMethods("get", null, true)));
            this.cachedPropertyMethods = all.toArray(new Method[all.size()]);
        }
        return this.cachedPropertyMethods;
    }

    public Method[] getAssertMethods() {
        if (this.cachedAssertMethods == null) {
            this.cachedAssertMethods = this.getMethods("assert", Boolean.TYPE, false);
        }
        return this.cachedAssertMethods;
    }

    public Method[] getComponentAssertMethods() {
        if (this.cachedComponentAssertMethods == null) {
            this.cachedComponentAssertMethods = this.getMethods("assert", Boolean.TYPE, true);
        }
        return this.cachedComponentAssertMethods;
    }

    public static String stripHTML(String str) {
        if (str != null && (str.startsWith("<html>") || str.startsWith("<HTML>"))) {
            int right;
            while (str.startsWith("<") && (right = str.indexOf(">")) != -1) {
                str = str.substring(right + 1);
            }
            while (str.endsWith(">") && (right = str.lastIndexOf("<")) != -1) {
                str = str.substring(0, right);
            }
        }
        return str;
    }

    protected void waitAction(String desc, Condition cond) throws ActionFailedException {
        try {
            this.wait(cond);
        }
        catch (WaitTimedOutError wto) {
            throw new ActionFailedException(desc);
        }
    }

    public Class getTestedClass(Class cls) {
        while (ComponentTester.getTester(cls.getSuperclass()) == this) {
            cls = cls.getSuperclass();
        }
        return cls;
    }

    public ComponentLocation parseLocation(String encoded) {
        return new ComponentLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point where) {
        return new ComponentLocation(where);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IGNORED_METHODS.addAll(Arrays.asList("actionSelectAWTMenuItemByLabel", "actionSelectAWTPopupMenuItemByLabel", "getTag", "getTester", "isOnPopup", "getLocation"));
        testers = new HashMap();
        tagMethods = new String[]{"getLabel", "getTitle", "getText"};
    }

    private class AWTMenuListener
    implements AWTEventListener {
        public volatile boolean eventFired;

        private AWTMenuListener() {
        }

        public void eventDispatched(AWTEvent e) {
            if (e.getID() == 1001) {
                this.eventFired = true;
            }
        }
    }
}

