/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.script.EventExceptionHandler;
import abbot.util.AWT;
import abbot.util.NonDelegatingClassLoader;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.EmptyStackException;
import javax.swing.SwingUtilities;

public class AppClassLoader
extends NonDelegatingClassLoader {
    private AppEventQueue eventQueue;
    private BootstrapClassLoader bootstrapLoader;
    private NonDelegatingClassLoader extensionsLoader;
    private boolean frameworkIsUnderTest = false;
    private ClassLoader oldClassLoader = null;
    private Thread installedThread = null;
    private String oldClassPath = null;
    private InstallationLock lock = new InstallationLock();
    private String[] mustReloadPrefixes = new String[]{"sun.applet."};
    static /* synthetic */ Class class$abbot$script$AppClassLoader;

    public AppClassLoader() {
        this((String)null);
    }

    public AppClassLoader(String classPath) {
        super(classPath, (class$abbot$script$AppClassLoader == null ? (class$abbot$script$AppClassLoader = AppClassLoader.class$("abbot.script.AppClassLoader")) : class$abbot$script$AppClassLoader).getClassLoader());
        this.bootstrapLoader = new BootstrapClassLoader();
        this.extensionsLoader = new NonDelegatingClassLoader(System.getProperty("java.class.path"), (class$abbot$script$AppClassLoader == null ? (class$abbot$script$AppClassLoader = AppClassLoader.class$("abbot.script.AppClassLoader")) : class$abbot$script$AppClassLoader).getClassLoader()){

            protected boolean shouldDelegate(String name) {
                return !AppClassLoader.this.isExtension(name);
            }
        };
    }

    public boolean isEventDispatchThread() {
        return this.eventQueue != null && Thread.currentThread() == this.eventQueue.thread || this.eventQueue == null && SwingUtilities.isEventDispatchThread();
    }

    protected boolean shouldDelegate(String name) {
        return this.bootstrapLoader.shouldDelegate(name) && !this.isExtension(name) && (!this.frameworkIsUnderTest || !this.isFrameworkClass(name));
    }

    private boolean isFrameworkClass(String name) {
        return name.startsWith("abbot.") || name.startsWith("junit.extensions.abbot.");
    }

    private boolean isExtension(String name) {
        return name.startsWith("abbot.tester.extensions.") || name.startsWith("abbot.script.parsers.extensions.");
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.isBootstrapClassRequiringReload(name)) {
            try {
                return this.bootstrapLoader.findClass(name);
            }
            catch (ClassNotFoundException cnf) {
                Log.warn(cnf);
            }
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException cnf) {
            if (this.isExtension(name)) {
                return this.extensionsLoader.findClass(name);
            }
            throw cnf;
        }
    }

    public void install() {
        Thread current;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException(Strings.get("appcl.invalid_state"));
        }
        if (this.installedThread != null) {
            String msg = Strings.get("appcl.already_installed", new Object[]{this.installedThread});
            throw new IllegalStateException(msg);
        }
        this.oldClassPath = System.getProperty("java.class.path");
        System.setProperty("abbot.class.path", this.oldClassPath);
        System.setProperty("java.class.path", this.getClassPath());
        Log.debug("java.class.path set to " + System.getProperty("java.class.path"));
        try {
            new EventExceptionHandler().install();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.eventQueue = new AppEventQueue();
        this.eventQueue.install();
        this.installedThread = current = Thread.currentThread();
        this.oldClassLoader = this.installedThread.getContextClassLoader();
        this.installedThread.setContextClassLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstalled() {
        InstallationLock installationLock = this.lock;
        synchronized (installationLock) {
            return this.eventQueue != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        InstallationLock installationLock = this.lock;
        synchronized (installationLock) {
            if (this.eventQueue != null) {
                this.eventQueue.uninstall();
                this.eventQueue = null;
            }
            if (this.installedThread != null) {
                this.installedThread.setContextClassLoader(this.oldClassLoader);
                this.oldClassLoader = null;
                this.installedThread = null;
                System.setProperty("java.class.path", this.oldClassPath);
                this.oldClassPath = null;
            }
        }
    }

    private boolean isBootstrapClassRequiringReload(String name) {
        for (int i = 0; i < this.mustReloadPrefixes.length; ++i) {
            if (!name.startsWith(this.mustReloadPrefixes[i])) continue;
            return true;
        }
        return false;
    }

    private static String getBootstrapPath() {
        return System.getProperty("sun.boot.class.path");
    }

    public String toString() {
        return super.toString() + " (java.class.path=" + System.getProperty("java.class.path") + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BootstrapClassLoader
    extends NonDelegatingClassLoader {
        public BootstrapClassLoader() {
            super(AppClassLoader.getBootstrapPath(), null);
        }

        protected boolean shouldDelegate(String name) {
            return !AppClassLoader.this.isBootstrapClassRequiringReload(name) && !"abbot.script.AppletSecurityManager".equals(name);
        }
    }

    private class AppEventQueue
    extends EventQueue {
        private Thread thread;

        private AppEventQueue() {
        }

        public void install() {
            Runnable installer = new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(AppEventQueue.this);
                }
            };
            AWT.invokeAndWait(installer);
            Runnable threadTagger = new Runnable(){

                public void run() {
                    AppEventQueue.this.thread = Thread.currentThread();
                    AppEventQueue.this.thread.setContextClassLoader(AppClassLoader.this);
                    AppEventQueue.this.thread.setName(AppEventQueue.this.thread.getName() + " (AppClassLoader)");
                }
            };
            AWT.invokeAndWait(threadTagger);
        }

        public void uninstall() {
            Log.debug("Uninstalling AppEventQueue");
            try {
                this.pop();
                this.thread = null;
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            Log.debug("AppEventQueue uninstalled");
        }

        public String toString() {
            return "Abbot AUT Event Queue (thread=" + this.thread + ")";
        }
    }

    private class InstallationLock {
        private InstallationLock() {
        }
    }
}

