/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveFail;

public class ShortAssert {
    private static final short ZERO = 0;
    private final short actual;

    ShortAssert(short actual) {
        this.actual = actual;
    }

    public ShortAssert isEqualTo(short expected) {
        PrimitiveFail.failIfNotEqual(this.actual, expected);
        return this;
    }

    public ShortAssert isNotEqualTo(short expected) {
        PrimitiveFail.failIfEqual(this.actual, expected);
        return this;
    }

    public ShortAssert isGreaterThan(short smaller) {
        PrimitiveFail.failIfNotGreaterThan(this.actual, smaller);
        return this;
    }

    public ShortAssert isLessThan(short bigger) {
        PrimitiveFail.failIfNotLessThan(this.actual, bigger);
        return this;
    }

    public ShortAssert isPositive() {
        return this.isGreaterThan((short)0);
    }

    public ShortAssert isNegative() {
        return this.isLessThan((short)0);
    }

    public ShortAssert isZero() {
        return this.isEqualTo((short)0);
    }
}

