/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortArrayAssert
extends GroupAssert<short[]> {
    ShortArrayAssert(short ... actual) {
        super(actual);
    }

    public ShortArrayAssert isNotNull() {
        return (ShortArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((short[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((short[])this.actual), ">"}));
        }
    }

    public ShortArrayAssert isNotEmpty() {
        if (((short[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public ShortArrayAssert isEqualTo(short[] expected) {
        if (!Arrays.equals((short[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((short[])this.actual)));
        }
        return this;
    }

    public ShortArrayAssert isNotEqualTo(short[] array) {
        if (Arrays.equals((short[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((short[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((short[])this.actual).length;
    }

    public ShortArrayAssert hasSize(int expected) {
        return (ShortArrayAssert)super.hasSize(expected);
    }

    public ShortArrayAssert isSameAs(short[] expected) {
        return (ShortArrayAssert)super.isSameAs(expected);
    }

    public ShortArrayAssert isNotSameAs(short[] expected) {
        return (ShortArrayAssert)super.isNotSameAs(expected);
    }
}

