/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Fail;
import org.fest.util.Strings;

public final class PrimitiveFail {
    static void failIfEqual(boolean first, boolean second) {
        if (first == second) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfEqual(char first, char second) {
        if (first == second) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfEqual(byte first, byte second) {
        if (first == second) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfEqual(short first, short second) {
        if (first == second) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfEqual(int first, int second) {
        if (first == second) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfEqual(long first, long second) {
        if (first == second) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfEqual(float first, float second) {
        if (Float.compare(first, second) == 0) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfEqual(double first, double second) {
        if (Double.compare(first, second) == 0) {
            Fail.fail(PrimitiveFail.errorMessageIfEqual(first, second));
        }
    }

    static String errorMessageIfEqual(boolean first, boolean second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static String errorMessageIfEqual(char first, char second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static String errorMessageIfEqual(byte first, byte second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static String errorMessageIfEqual(short first, short second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static String errorMessageIfEqual(int first, int second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static String errorMessageIfEqual(long first, long second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static String errorMessageIfEqual(float first, float second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static String errorMessageIfEqual(double first, double second) {
        return Strings.concat((Object[])new Object[]{"<", String.valueOf(first), "> should not be equal to <", String.valueOf(second), ">"});
    }

    static void failIfNotEqual(boolean actual, boolean expected) {
        if (actual != expected) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNotEqual(char actual, char expected) {
        if (actual != expected) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNotEqual(byte actual, byte expected) {
        if (actual != expected) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNotEqual(short actual, short expected) {
        if (actual != expected) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNotEqual(int actual, int expected) {
        if (actual != expected) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNotEqual(long actual, long expected) {
        if (actual != expected) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNotEqual(float actual, float expected) {
        if (Float.compare(actual, expected) != 0) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNotEqual(double actual, double expected) {
        if (Double.compare(actual, expected) != 0) {
            Fail.fail(PrimitiveFail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static String errorMessageIfNotEqual(boolean actual, boolean expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static String errorMessageIfNotEqual(char actual, char expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static String errorMessageIfNotEqual(byte actual, byte expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static String errorMessageIfNotEqual(short actual, short expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static String errorMessageIfNotEqual(int actual, int expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static String errorMessageIfNotEqual(long actual, long expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static String errorMessageIfNotEqual(float actual, float expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static String errorMessageIfNotEqual(double actual, double expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", String.valueOf(expected), "> but was:<", String.valueOf(actual), ">"});
    }

    static void failIfNotLessThan(char first, char second) {
        if (first >= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotLessThan(first, second));
        }
    }

    static void failIfNotLessThan(byte first, byte second) {
        if (first >= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotLessThan(first, second));
        }
    }

    static void failIfNotLessThan(short first, short second) {
        if (first >= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotLessThan(first, second));
        }
    }

    static void failIfNotLessThan(int first, int second) {
        if (first >= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotLessThan(first, second));
        }
    }

    static void failIfNotLessThan(long first, long second) {
        if (first >= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotLessThan(first, second));
        }
    }

    static void failIfNotLessThan(float first, float second) {
        if (Float.compare(first, second) >= 0) {
            Fail.fail(PrimitiveFail.errorMessageIfNotLessThan(first, second));
        }
    }

    static void failIfNotLessThan(double first, double second) {
        if (Double.compare(first, second) >= 0) {
            Fail.fail(PrimitiveFail.errorMessageIfNotLessThan(first, second));
        }
    }

    static String errorMessageIfNotLessThan(char first, char second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be less than ", String.valueOf(second)});
    }

    static String errorMessageIfNotLessThan(byte first, byte second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be less than ", String.valueOf(second)});
    }

    static String errorMessageIfNotLessThan(short first, short second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be less than ", String.valueOf(second)});
    }

    static String errorMessageIfNotLessThan(int first, int second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be less than ", String.valueOf(second)});
    }

    static String errorMessageIfNotLessThan(long first, long second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be less than ", String.valueOf(second)});
    }

    static String errorMessageIfNotLessThan(float first, float second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be less than ", String.valueOf(second)});
    }

    static String errorMessageIfNotLessThan(double first, double second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be less than ", String.valueOf(second)});
    }

    static void failIfNotGreaterThan(char first, char second) {
        if (first <= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotGreaterThan(first, second));
        }
    }

    static void failIfNotGreaterThan(byte first, byte second) {
        if (first <= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotGreaterThan(first, second));
        }
    }

    static void failIfNotGreaterThan(short first, short second) {
        if (first <= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotGreaterThan(first, second));
        }
    }

    static void failIfNotGreaterThan(int first, int second) {
        if (first <= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotGreaterThan(first, second));
        }
    }

    static void failIfNotGreaterThan(long first, long second) {
        if (first <= second) {
            Fail.fail(PrimitiveFail.errorMessageIfNotGreaterThan(first, second));
        }
    }

    static void failIfNotGreaterThan(float first, float second) {
        if (Float.compare(first, second) <= 0) {
            Fail.fail(PrimitiveFail.errorMessageIfNotGreaterThan(first, second));
        }
    }

    static void failIfNotGreaterThan(double first, double second) {
        if (Double.compare(first, second) <= 0) {
            Fail.fail(PrimitiveFail.errorMessageIfNotGreaterThan(first, second));
        }
    }

    static String errorMessageIfNotGreaterThan(char first, char second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be greater than ", String.valueOf(second)});
    }

    static String errorMessageIfNotGreaterThan(byte first, byte second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be greater than ", String.valueOf(second)});
    }

    static String errorMessageIfNotGreaterThan(short first, short second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be greater than ", String.valueOf(second)});
    }

    static String errorMessageIfNotGreaterThan(int first, int second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be greater than ", String.valueOf(second)});
    }

    static String errorMessageIfNotGreaterThan(long first, long second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be greater than ", String.valueOf(second)});
    }

    static String errorMessageIfNotGreaterThan(float first, float second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be greater than ", String.valueOf(second)});
    }

    static String errorMessageIfNotGreaterThan(double first, double second) {
        return Strings.concat((Object[])new Object[]{String.valueOf(first), " should be greater than ", String.valueOf(second)});
    }

    private PrimitiveFail() {
    }
}

