/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveFail;

public class LongAssert {
    private static final long ZERO = 0L;
    private final long actual;

    LongAssert(long actual) {
        this.actual = actual;
    }

    public LongAssert isEqualTo(long expected) {
        PrimitiveFail.failIfNotEqual(this.actual, expected);
        return this;
    }

    public LongAssert isNotEqualTo(long expected) {
        PrimitiveFail.failIfEqual(this.actual, expected);
        return this;
    }

    public LongAssert isGreaterThan(long smaller) {
        PrimitiveFail.failIfNotGreaterThan(this.actual, smaller);
        return this;
    }

    public LongAssert isLessThan(long bigger) {
        PrimitiveFail.failIfNotLessThan(this.actual, bigger);
        return this;
    }

    public LongAssert isPositive() {
        return this.isGreaterThan(0L);
    }

    public LongAssert isNegative() {
        return this.isLessThan(0L);
    }

    public LongAssert isZero() {
        return this.isEqualTo(0L);
    }
}

