/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongArrayAssert
extends GroupAssert<long[]> {
    LongArrayAssert(long ... actual) {
        super(actual);
    }

    public LongArrayAssert isNotNull() {
        return (LongArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((long[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((long[])this.actual), ">"}));
        }
    }

    public LongArrayAssert isNotEmpty() {
        if (((long[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public LongArrayAssert isEqualTo(long[] expected) {
        if (!Arrays.equals((long[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((long[])this.actual)));
        }
        return this;
    }

    public LongArrayAssert isNotEqualTo(long[] array) {
        if (Arrays.equals((long[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((long[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((long[])this.actual).length;
    }

    public LongArrayAssert hasSize(int expected) {
        return (LongArrayAssert)super.hasSize(expected);
    }

    public LongArrayAssert isSameAs(long[] expected) {
        return (LongArrayAssert)super.isSameAs(expected);
    }

    public LongArrayAssert isNotSameAs(long[] expected) {
        return (LongArrayAssert)super.isNotSameAs(expected);
    }
}

