/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Collection;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Collections;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionAssert
extends GroupAssert<Collection<?>> {
    CollectionAssert(Collection<?> actual) {
        super(actual);
    }

    public CollectionAssert doesNotHaveDuplicates() {
        Collection duplicates = Collections.duplicatesFrom((Collection)((Collection)this.actual));
        if (!duplicates.isEmpty()) {
            Fail.fail(Strings.concat((Object[])new Object[]{"the collection ", this.actual, " contains duplicates (", duplicates, ")"}));
        }
        return this;
    }

    public CollectionAssert isNotNull() {
        if (this.actual == null) {
            Fail.fail("the collection is null");
        }
        return this;
    }

    @Override
    public void isEmpty() {
        if (!Collections.isEmpty((Collection)((Collection)this.actual))) {
            Fail.fail(Strings.concat((Object[])new Object[]{"the collection ", this.actual, " is not empty"}));
        }
    }

    public CollectionAssert isNotEmpty() {
        if (Collections.isEmpty((Collection)((Collection)this.actual))) {
            Fail.fail("the collection is null or empty");
        }
        return this;
    }

    public CollectionAssert hasSize(int expected) {
        return (CollectionAssert)super.hasSize(expected);
    }

    @Override
    int actualGroupSize() {
        return ((Collection)this.actual).size();
    }

    public CollectionAssert isEqualTo(Collection<?> expected) {
        return (CollectionAssert)super.isEqualTo(expected);
    }

    public CollectionAssert isNotEqualTo(Collection<?> obj) {
        return (CollectionAssert)super.isNotEqualTo(obj);
    }

    public CollectionAssert isSameAs(Collection<?> expected) {
        return (CollectionAssert)super.isSameAs(expected);
    }

    public CollectionAssert isNotSameAs(Collection<?> expected) {
        return (CollectionAssert)super.isNotSameAs(expected);
    }
}

