/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Fail;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharArrayAssert
extends GroupAssert<char[]> {
    CharArrayAssert(char ... actual) {
        super(actual);
    }

    public CharArrayAssert isNotNull() {
        return (CharArrayAssert)super.isNotNull();
    }

    @Override
    public void isEmpty() {
        if (((char[])this.actual).length > 0) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was <", Arrays.toString((char[])this.actual), ">"}));
        }
    }

    public CharArrayAssert isNotEmpty() {
        if (((char[])this.actual).length == 0) {
            Fail.fail("expecting non-empty array");
        }
        return this;
    }

    public CharArrayAssert isEqualTo(char[] expected) {
        if (!Arrays.equals((char[])this.actual, expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(Arrays.toString(expected), Arrays.toString((char[])this.actual)));
        }
        return this;
    }

    public CharArrayAssert isNotEqualTo(char[] array) {
        if (Arrays.equals((char[])this.actual, array)) {
            Fail.fail(Fail.errorMessageIfEqual(Arrays.toString((char[])this.actual), Arrays.toString(array)));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        return ((char[])this.actual).length;
    }

    public CharArrayAssert hasSize(int expected) {
        return (CharArrayAssert)super.hasSize(expected);
    }

    public CharArrayAssert isSameAs(char[] expected) {
        return (CharArrayAssert)super.isSameAs(expected);
    }

    public CharArrayAssert isNotSameAs(char[] expected) {
        return (CharArrayAssert)super.isNotSameAs(expected);
    }
}

