/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.command.ActiveMQDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityContext {
    public static final SecurityContext BROKER_SECURITY_CONTEXT = new SecurityContext("ActiveMQBroker"){

        @Override
        public boolean isBrokerContext() {
            return true;
        }

        @Override
        public Set<?> getPrincipals() {
            return Collections.EMPTY_SET;
        }
    };
    final String userName;
    final ConcurrentHashMap<ActiveMQDestination, ActiveMQDestination> authorizedReadDests = new ConcurrentHashMap();
    final ConcurrentHashMap<ActiveMQDestination, ActiveMQDestination> authorizedWriteDests = new ConcurrentHashMap();

    public SecurityContext(String userName) {
        this.userName = userName;
    }

    public boolean isInOneOf(Set<?> allowedPrincipals) {
        HashSet set = new HashSet(this.getPrincipals());
        set.retainAll(allowedPrincipals);
        return set.size() > 0;
    }

    public abstract Set<?> getPrincipals();

    public String getUserName() {
        return this.userName;
    }

    public ConcurrentHashMap<ActiveMQDestination, ActiveMQDestination> getAuthorizedReadDests() {
        return this.authorizedReadDests;
    }

    public ConcurrentHashMap<ActiveMQDestination, ActiveMQDestination> getAuthorizedWriteDests() {
        return this.authorizedWriteDests;
    }

    public boolean isBrokerContext() {
        return false;
    }
}

