/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.activemq.test.TestSupport;
import org.apache.activemq.transport.mock.MockTransport;

public class ConnectionFailureEvictsFromPool
extends TestSupport {
    private BrokerService broker;
    private ActiveMQConnectionFactory factory;
    private PooledConnectionFactory pooledFactory;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        TransportConnector connector = this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory("mock:" + connector.getConnectUri());
        this.pooledFactory = new PooledConnectionFactory(this.factory);
    }

    public void testEviction() throws Exception {
        Connection connection = this.pooledFactory.createConnection();
        this.sendMessage(connection);
        this.createConnectionFailure(connection);
        try {
            this.sendMessage(connection);
            ConnectionFailureEvictsFromPool.fail((String)"Expected Error");
        }
        catch (JMSException e) {
            // empty catch block
        }
        Connection connection2 = this.pooledFactory.createConnection();
        this.sendMessage(connection2);
    }

    private void createConnectionFailure(Connection connection) throws Exception {
        ActiveMQConnection c = ((PooledConnection)connection).getConnection();
        MockTransport t = c.getTransportChannel().narrow(MockTransport.class);
        t.stop();
    }

    private void sendMessage(Connection connection) throws JMSException {
        Session session = connection.createSession(false, 0);
        MessageProducer producer = session.createProducer(new ActiveMQQueue("FOO"));
        producer.send(session.createTextMessage("Test"));
        session.close();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
    }
}

