/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.jms.Connection;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.textui.TestRunner;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PurgeTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(PurgeTest.class);
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected String clientID = "foo";
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;
    protected int messageCount = 10;

    public static void main(String[] args) {
        TestRunner.run(PurgeTest.class);
    }

    public void testPurge() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID(this.clientID);
        this.connection.start();
        Session session = this.connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer(this.destination);
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = session.createTextMessage("Message: " + i);
            producer.send(message);
        }
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":Type=Queue,Destination=" + this.getDestinationString() + ",BrokerName=localhost");
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        proxy.purge();
        count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)0L);
        this.messageCount += 1000;
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = session.createTextMessage("Message: " + i);
            producer.send(message);
        }
        count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        proxy.purge();
        count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)0L);
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            this.echo("Bean Registered: " + objectName);
        } else {
            PurgeTest.fail((String)("Could not find MBean!: " + objectName));
        }
        return objectName;
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        this.useTopic = false;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(true);
        answer.setEnableStatistics(true);
        answer.setPersistent(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void echo(String text) {
        LOG.info(text);
    }
}

