/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Level;

public class Handler {
    private static Level s_level = Level.MAX_VALUE;

    public static int muteStatus() {
        return Handler.setStatusLevel(Level.MUTE);
    }

    public static int setStatusTop() {
        return Handler.setStatusLevel(Level.TOP);
    }

    public static int setStatusInfo() {
        return Handler.setStatusLevel(Level.INFO);
    }

    public static int setStatusMax() {
        return Handler.setStatusLevel(Level.MAX_VALUE);
    }

    public static int setStatus(int level) {
        return Handler.setStatusLevel(Level.byId(level));
    }

    public static void reportError(Exception e) {
        SRAToolkit.errPrintln(e);
    }

    public static void reportError(String msg) {
        SRAToolkit.errPrintln(msg);
    }

    public static void reportWarning(String msg) {
        SRAToolkit.errPrintln(msg);
    }

    public static void reportStatusTop(String msg) {
        Handler.reportStatus(msg, Level.TOP);
    }

    public static void reportStatusInfo(String msg) {
        Handler.reportStatus(msg, Level.INFO);
    }

    public static void reportStatusDbg(String msg) {
        Handler.reportStatus(msg, Level.DBG);
    }

    private static void reportStatus(String msg, Level level) {
        if (Handler.muted(level)) {
            return;
        }
        if (level.id() >= Level.DBG.id()) {
            SRAToolkit.debugPrintln(msg);
        } else {
            SRAToolkit.println(msg);
        }
    }

    private static boolean muted(Level level) {
        return s_level.id() < level.id();
    }

    private static int setStatusLevel(Level level) {
        int old = s_level.id();
        s_level = level;
        return old;
    }
}

