/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseq;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.VResolverResult;
import gov.nih.nlm.ncbi.vdb.vfs.VFSManager;
import gov.nih.nlm.ncbi.vdb.vfs.VResolver;
import java.io.File;

public class VResolverProxy {
    private VResolver resolver;

    public VResolverProxy(KConfig cfg) throws VDBException {
        VFSManager mgr = VFSManager.make();
        this.resolver = mgr.makeVResolver(cfg);
        try {
            mgr.release();
        }
        catch (VDBException e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    protected void finalize() throws Throwable {
        this.resolver.release();
    }

    public VResolverResult resolveAcc(String accession) throws Exception {
        String local = this.resolver.local(accession);
        String remote = this.resolver.remote(accession);
        String cache = null;
        if (remote != null) {
            cache = this.resolver.cache(remote);
        }
        return new VResolverResult(accession, local, remote, cache);
    }

    VResolverResult resolveUrl(String remote) throws Exception {
        String cache = this.resolver.cache(remote);
        String local = null;
        if (new File(cache).exists()) {
            local = cache;
        }
        return new VResolverResult(remote, local, remote, cache);
    }
}

