/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseq;

import gov.nih.nlm.ncbi.vdb.kfs.KFSPath;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqFactory;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqPackedHelper;
import gov.nih.nlm.ncbi.vdb.vdb.PathType;
import gov.nih.nlm.ncbi.vdb.vdb.VDBDependencies;
import gov.nih.nlm.ncbi.vdb.vdb.VDBManager;
import java.io.File;

public class VDBManagerProxy {
    private boolean quick = true;
    private VDBManager mgr;
    private RefseqFactory factory;

    public VDBManagerProxy(RefseqFactory factory) throws VDBException {
        this.factory = factory;
        this.mgr = VDBManager.make();
    }

    protected void finalize() throws Throwable {
        this.mgr.release();
    }

    public RefseqList listDependencies(String path) throws VDBException {
        path = KFSPath.systemStringToPosixString(path);
        VDBDependencies dep = this.mgr.makeVDBDependencies(path);
        RefseqList list = this.factory.makeList(dep);
        dep.release();
        return list;
    }

    PathType pathType(String name) {
        return this.pathTypeMergingPrereleaseTbl(name);
    }

    public PathType pathType(File f) {
        if (f.isDirectory()) {
            return this.detectDirType(f);
        }
        return this.pathTypeMergingPrereleaseTbl(f.getAbsolutePath());
    }

    public PathType pathTypeMergingPrereleaseTbl(String path) {
        try {
            path = KFSPath.systemStringToPosixString(path);
        }
        catch (VDBException e) {
            return PathType.FAILURE;
        }
        PathType t = this.mgr.pathType(path);
        if (t == PathType.PRERELEASE_TBL) {
            t = PathType.TABLE;
        }
        return t;
    }

    private PathType detectDirType(File dir) {
        boolean hasTbl = false;
        boolean hasCol = false;
        if (this.quick) {
            File col;
            File tbl = new File(dir, "tbl");
            if (tbl.exists()) {
                hasTbl = true;
            }
            if ((col = new File(dir, "col")).exists()) {
                hasCol = true;
            }
        }
        if (!this.quick || hasTbl || hasCol) {
            return this.pathTypeMergingPrereleaseTbl(dir.getAbsolutePath());
        }
        return PathType.UNKNOWN;
    }

    private static void test(VDBManagerProxy mgr, String path) throws Exception {
        SRAToolkit.debugPrintln("dep(" + path + ") = " + mgr.listDependencies(path));
    }

    private static void pathTypeTest(VDBManagerProxy mgr) throws Exception {
        String path = null;
        PathType t = mgr.pathType(new File(path));
        SRAToolkit.debugPrintln("pathType(" + path + ") = " + (Object)((Object)t));
        if (t != PathType.UNKNOWN) {
            throw new Exception("Unexpected type for " + path);
        }
        t = mgr.pathType(new File(path));
        SRAToolkit.debugPrintln("pathType(" + path + ") = " + (Object)((Object)t));
        if (t != PathType.TABLE) {
            throw new Exception("Unexpected type for " + path);
        }
        t = mgr.pathType(new File(path));
        SRAToolkit.debugPrintln("pathType(" + path + ") = " + (Object)((Object)t));
        if (t != PathType.DATABASE) {
            throw new Exception("Unexpected type for " + path);
        }
    }

    public static void MAIN(String[] args) {
        SRAToolkit.setDebug();
        System.loadLibrary("vdb_jni");
        try {
            VDBManagerProxy mgr = null;
            SRAToolkit.debugPrintln("mgr = " + mgr);
            SRAToolkit.debugPrintln("creating VDBManagerProxy");
            mgr = new VDBManagerProxy(RefseqFactory.makeWithPackingBeforeDownload(new RefseqPackedHelper("packed.txt")));
            SRAToolkit.debugPrintln("mgr = " + mgr);
            try {
                VDBManagerProxy.pathTypeTest(mgr);
            }
            catch (Exception e) {
                SRAToolkit.debugPrintln("Exception during pathTypeTest: " + e);
            }
        }
        catch (Exception e) {
            SRAToolkit.debugPrintln("Exception caught: " + e);
        }
    }
}

