/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.net;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;

public class WebAccessor {
    public static boolean canConnect(String spec) {
        try {
            URL url = new URL(spec);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int code = conn.getResponseCode();
            return code == 200;
        }
        catch (MalformedURLException e) {
            SRAToolkit.stackTracePrint(e);
        }
        catch (IOException e) {
            SRAToolkit.stackTracePrint(e);
        }
        return false;
    }

    public static int getSize(String spec) throws IOException {
        if (spec == null) {
            throw new NullPointerException();
        }
        URL url = new URL(spec);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("HEAD");
        conn.getInputStream();
        return conn.getContentLength();
    }

    public static boolean download(String from, String to) {
        Handler.reportStatusInfo(from + " -> " + to);
        try {
            Handler.reportStatusInfo("creating " + to);
            FileOutputStream out = new FileOutputStream(to);
            Lock lock = WebAccessor.tryLock(out);
            if (!lock.locked()) {
                Handler.reportWarning(from + " is already being downloaded");
                return false;
            }
            URL url = new URL(from);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            int sz = 1024;
            BufferedOutputStream bout = new BufferedOutputStream(out, sz);
            byte[] data = new byte[sz];
            int count = 0;
            while ((count = in.read(data, 0, sz)) != -1) {
                bout.write(data, 0, count);
            }
            bout.close();
            out.close();
            in.close();
            File tmp = new File(to);
            Handler.reportStatusDbg(to + ": " + tmp.length());
            return true;
        }
        catch (MalformedURLException e) {
            SRAToolkit.stackTracePrint(e);
        }
        catch (IOException e) {
            SRAToolkit.stackTracePrint(e);
        }
        return false;
    }

    private static Lock tryLock(FileOutputStream out) {
        Lock lock = new Lock(out);
        return lock;
    }

    private static class Lock {
        private FileLock lock;

        private Lock(FileOutputStream out) {
            try {
                this.lock = out.getChannel().tryLock();
            }
            catch (IOException e) {
                SRAToolkit.stackTracePrint(e);
                this.lock = null;
            }
        }

        private boolean locked() {
            return this.lock != null;
        }
    }
}

