/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SRAToolkitRepositoryPreferences
extends JPanel {
    private String[] children;
    private JComboBox catList;
    private JComboBox repList;
    private JCheckBox cache;
    private JCheckBox disabled;
    private GroupLayout layout;
    private JLabel nameLabel;
    private JLabel browseLabel;
    private JLabel selectLabel;
    private String currentDir = "";
    private String repName;
    private JButton browseButton;
    private JTextField pathInput;
    private JTextField nameInput;
    private JPanel mainPanel = new JPanel();
    private JPanel dropDownPanel = new JPanel();
    private String selectedCat;
    private String selectedRep;
    private boolean cacheModified = false;
    private boolean disabledModified = false;
    private boolean pathModified = false;
    private JButton ok;
    private JButton cancel;
    private JPanel buttonPanel;
    private KConfig config;
    private static SRAToolkitPreferences mgr;

    public static SRAToolkitRepositoryPreferences make(SRAToolkitPreferences _mgr, KConfig _config) {
        mgr = _mgr;
        SRAToolkitRepositoryPreferences panel = null;
        panel = new SRAToolkitRepositoryPreferences(_config);
        return panel;
    }

    private void configLayout() {
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.browseLabel).addComponent(this.disabled)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cache)));
        this.layout.setVerticalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseLabel)).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.disabled).addComponent(this.cache)));
    }

    private void buildCategoryList() {
        DefaultComboBoxModel<String> model = null;
        KConfigNode node = null;
        boolean noSite = true;
        try {
            node = this.config.openNodeRead("/repository/site");
            noSite = false;
        }
        catch (Exception e) {
            // empty catch block
        }
        final String[] categories = noSite ? new String[]{"Remote", "User"} : new String[]{"Remote", "Site", "User"};
        model = new DefaultComboBoxModel<String>(categories);
        this.selectLabel = new JLabel("Select Category:  ");
        this.catList = new JComboBox<String>(model);
        this.catList.setEditable(false);
        if (noSite) {
            this.catList.setSelectedIndex(1);
        } else {
            this.catList.setSelectedIndex(2);
        }
        this.catList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int obj = SRAToolkitRepositoryPreferences.this.catList.getSelectedIndex();
                String selectedCat = categories[obj];
                SRAToolkitRepositoryPreferences.this.setSelectedCat(selectedCat);
                SRAToolkitRepositoryPreferences.this.updateSelection();
                SRAToolkitRepositoryPreferences.this.updateMainPanel();
            }
        });
        this.dropDownPanel.add(this.selectLabel);
        this.dropDownPanel.add(this.catList);
    }

    private void buildRepositoryList() {
        DefaultComboBoxModel<String> model = null;
        try {
            KConfigNode node = this.config.openNodeRead("/repository/" + this.selectedCat + "/" + "main");
            if (node != null) {
                this.children = node.listChildren();
                model = new DefaultComboBoxModel<String>(this.children);
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        this.selectLabel = new JLabel("Select Repository:  ");
        this.setSelectedRep(this.children[0]);
        this.repList = new JComboBox(model);
        this.repList.setEditable(false);
        this.repList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int obj = SRAToolkitRepositoryPreferences.this.repList.getSelectedIndex();
                String selectedRep = SRAToolkitRepositoryPreferences.this.children[obj];
                SRAToolkitRepositoryPreferences.this.setSelectedRep(selectedRep);
                SRAToolkitRepositoryPreferences.this.updateMainPanel();
            }
        });
        this.dropDownPanel.add(this.selectLabel);
        this.dropDownPanel.add(this.repList);
    }

    private void updateSelection() {
        this.dropDownPanel.remove(this.selectLabel);
        this.dropDownPanel.remove(this.repList);
        this.buildRepositoryList();
        this.getParent().repaint();
    }

    private void updateMainPanel() {
        this.mainPanel.removeAll();
        this.remove(this.mainPanel);
        this.buildMainPanel();
        this.add((Component)this.mainPanel, "Center");
        this.getParent().repaint();
    }

    private void setSelectedCat(String name) {
        this.selectedCat = name.toLowerCase();
    }

    private void setSelectedRep(String name) {
        this.selectedRep = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMainPanel() {
        this.layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(this.layout);
        this.mainPanel.setBackground(Color.white);
        boolean isDisabled = false;
        boolean cacheEnabled = false;
        try {
            KConfigNode rep = this.config.openNodeRead("/repository/" + this.selectedCat + "/main/" + this.selectedRep);
            this.currentDir = "";
            try {
                KConfigNode child;
                String name = this.selectedRep.equals("CGI") ? "resolver-cgi" : "root";
                this.currentDir = rep.readString(name);
                try {
                    child = rep.openNodeRead("disabled");
                    try {
                        isDisabled = child.read().equals("true");
                    }
                    finally {
                        child.release();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    child = rep.openNodeRead("cache-enabled");
                    try {
                        cacheEnabled = child.read().equals("true");
                    }
                    finally {
                        child.release();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                rep.release();
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        this.nameLabel = new JLabel("Repository Name:  " + this.selectedRep);
        this.browseLabel = new JLabel("Path to Repository: " + this.currentDir);
        this.cache = new JCheckBox("Cache-Enabled");
        this.cache.setSelected(cacheEnabled);
        this.cache.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    KConfigNode rep = SRAToolkitRepositoryPreferences.this.config.openNodeUpdate("/repository/" + SRAToolkitRepositoryPreferences.this.selectedCat + "/main/" + SRAToolkitRepositoryPreferences.this.selectedRep);
                    try {
                        String which = SRAToolkitRepositoryPreferences.this.cache.isSelected() ? "true" : "false";
                        KConfigNode cacheNode = rep.openNodeUpdate("cache-enabled");
                        try {
                            cacheNode.write(which);
                            SRAToolkitRepositoryPreferences.this.cacheModified = true;
                        }
                        finally {
                            cacheNode.release();
                        }
                    }
                    finally {
                        rep.release();
                    }
                }
                catch (Exception e) {
                    SRAToolkit.stackTracePrint(e);
                }
            }
        });
        this.disabled = new JCheckBox("Disable Repository");
        this.disabled.setSelected(isDisabled);
        this.disabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String which = SRAToolkitRepositoryPreferences.this.disabled.isSelected() ? "true" : "false";
                SRAToolkitRepositoryPreferences.this.disabledModified = SRAToolkit.setRepoDisabled(SRAToolkitRepositoryPreferences.this.config, which, "main", SRAToolkitRepositoryPreferences.this.selectedRep, SRAToolkitRepositoryPreferences.this.selectedCat);
                SRAToolkitRepositoryPreferences.this.disabledModified = (byte)(SRAToolkitRepositoryPreferences.this.disabledModified | (SRAToolkit.setRepoDisabled(SRAToolkitRepositoryPreferences.this.config, which, "aux", null, SRAToolkitRepositoryPreferences.this.selectedCat) ? 1 : 0));
            }
        });
        if (this.selectedCat.equals("site")) {
            this.cache.setEnabled(false);
        }
        if (this.selectedCat.equals("remote")) {
            this.cache.setEnabled(false);
        }
        if (this.selectedCat.equals("user")) {
            this.cache.setEnabled(true);
            this.disabled.setEnabled(false);
        }
        this.configLayout();
    }

    private void buildButtonPanel() {
        this.buttonPanel = new JPanel();
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                try {
                    if (SRAToolkitRepositoryPreferences.this.isModified()) {
                        SRAToolkitRepositoryPreferences.this.config.commit();
                        mgr.readyToUpdate();
                    }
                    SRAToolkitRepositoryPreferences.this.config.release();
                    mgr.closePreferences();
                }
                catch (Exception e) {
                    SRAToolkit.stackTracePrint(e);
                }
            }
        });
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                try {
                    SRAToolkitRepositoryPreferences.this.config.release();
                    mgr.closePreferences();
                }
                catch (Exception e) {
                    SRAToolkit.stackTracePrint(e);
                }
            }
        });
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.add(this.ok);
    }

    private boolean isModified() {
        return this.cacheModified || this.disabledModified || this.pathModified;
    }

    private SRAToolkitRepositoryPreferences(KConfig _config) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        try {
            this.config = (KConfig)_config.duplicate();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        this.setSelectedCat("User");
        this.buildCategoryList();
        this.buildRepositoryList();
        this.buildMainPanel();
        this.buildButtonPanel();
        this.add((Component)this.dropDownPanel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.setPreferredSize(new Dimension(600, 400));
    }
}

