/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import java.io.File;

public class SRAToolkitShell
implements Runnable {
    private SRAToolkit app;
    private String workingDirectory = null;

    public SRAToolkitShell(SRAToolkit app) {
        this.app = app;
        try {
            this.workingDirectory = new File(".").getCanonicalPath();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    @Override
    public void run() {
    }

    public void parseArgs(String cmdLine) throws Exception {
        SRAToolkit.debugPrintln(this.workingDirectory + "$ " + cmdLine);
        String[] args = cmdLine.split("[ ]+");
        if (args[0].equals("ls")) {
            this.app.addToEventQueue(new LSCommand());
        } else if (args[0].equals("pwd")) {
            SRAToolkit.println(this.workingDirectory);
        } else if (args[0].equals("cd")) {
            this.app.addToEventQueue(new CDCommand(args));
        }
    }

    private File[] getChildren() {
        File wd = new File(this.workingDirectory);
        File[] children = wd.listFiles();
        return children;
    }

    private String calculateOffset(File[] children) {
        int i;
        int max = 0;
        for (i = 0; i < children.length; ++i) {
            int child = children[i].getName().length();
            if (child <= max) continue;
            max = child;
        }
        String offset = "     ";
        for (i = 0; i < max - 1; ++i) {
            offset = offset + " ";
        }
        return offset;
    }

    private class CDCommand
    extends Command {
        private String[] args;

        CDCommand(String[] args) {
            super(null, null);
            this.args = args;
        }

        @Override
        protected boolean execute() throws Exception {
            if (this.args.length == 2) {
                String path = null;
                if (this.args[1].startsWith("..")) {
                    String[] parse = this.args[1].split("/");
                    for (int i = 0; i < parse.length; ++i) {
                        path = SRAToolkitShell.this.workingDirectory;
                        int endIndex = path.lastIndexOf("/");
                        path = path.substring(0, endIndex);
                        SRAToolkitShell.this.workingDirectory = path;
                        SRAToolkit.println(path);
                    }
                } else {
                    String[] parse = this.args[1].split("/");
                    for (int i = 0; i < parse.length; ++i) {
                        int index = -1;
                        File[] children = SRAToolkitShell.this.getChildren();
                        int j = 0;
                        while (i < children.length) {
                            if (parse[i].equals(children[j].getName())) {
                                index = j;
                                break;
                            }
                            ++j;
                        }
                        if (index != -1) {
                            if (children[index].isDirectory()) {
                                path = children[index].getPath();
                                SRAToolkitShell.this.workingDirectory = path;
                                path = null;
                                continue;
                            }
                            SRAToolkit.errPrintln(SRAToolkitShell.this.workingDirectory + "/" + this.args[1] + ": Not a directory");
                            continue;
                        }
                        SRAToolkit.errPrintln(SRAToolkitShell.this.workingDirectory + "/" + this.args[1] + ": No such file or directory");
                    }
                }
            } else {
                try {
                    SRAToolkitShell.this.workingDirectory = new File(".").getCanonicalPath();
                }
                catch (Exception e) {
                    SRAToolkit.stackTracePrint(e);
                }
            }
            return true;
        }
    }

    private class LSCommand
    extends Command {
        LSCommand() {
            super(null, null);
        }

        @Override
        protected boolean execute() throws Exception {
            File[] children = SRAToolkitShell.this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                String out;
                String row = null;
                if (children[i].isHidden()) continue;
                String offset = SRAToolkitShell.this.calculateOffset(children);
                if (children[i].isDirectory()) {
                    String dir = children[i].getName();
                    offset = offset.substring(dir.length(), offset.lastIndexOf(32));
                    out = dir + offset;
                    SRAToolkit.print(out);
                    row = row + out;
                    if (i % 6 != 0 && row.length() <= 1280) continue;
                    SRAToolkit.print("\n");
                    continue;
                }
                String file = children[i].getName();
                offset = offset.substring(file.length(), offset.lastIndexOf(32));
                out = file + offset;
                SRAToolkit.print(out);
                row = row + out;
                if (i % 6 != 0 && row.length() <= 1280) continue;
                SRAToolkit.print("\n");
            }
            SRAToolkit.print("\n");
            return true;
        }
    }
}

