/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqMgr;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.SraListener;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.VResolverResult;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.Refseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import java.util.Iterator;

class ResolveSraCommand
extends Command {
    private String accession;
    private RefseqMgr mgr;
    private SraListener resolver;
    private SraListener downloader;

    ResolveSraCommand(String accession, RefseqMgr mgr, SraListener resolver, SraListener downloader) {
        if (accession == null || mgr == null) {
            throw new NullPointerException();
        }
        this.accession = accession;
        this.mgr = mgr;
        this.resolver = resolver;
        this.downloader = downloader;
    }

    @Override
    protected boolean execute() throws Exception {
        Handler.reportStatusTop(this.myNumber() + "Resolving accession " + this.accession + " and dependencies...");
        boolean ok = true;
        VResolverResult res = this.mgr.resolveSra(this.accession);
        if (res.foundLocally()) {
            String path = res.local();
            Handler.reportStatusTop(this.myNumber() + this.accession + " found locally: " + path + ". Checking references...");
            RefseqList l = this.mgr.listReferences(path);
            Iterator<Refseq> it = l.externalIterator();
            while (it.hasNext()) {
                Refseq r = it.next();
                if (r.isResolved() || this.downloader == null) continue;
                ok &= this.downloader.event(r);
            }
            Handler.reportStatusTop(this.myNumber() + "References check of " + this.accession + (ok ? " succeed" : " failed"));
        } else {
            Handler.reportStatusTop(this.myNumber() + this.accession + " not found: creating download command");
            if (this.resolver != null) {
                ok = this.resolver.event(res);
            }
        }
        return ok;
    }
}

