/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.AddRepositoryCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.FTPCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SerialCommandPair;

public abstract class Command
implements Runnable {
    protected SRAToolkit app;
    protected Object obj;
    private int number;
    private static int s_number = 0;

    @Override
    public final void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    public static Command makeAddRepositoryCommand(SRAToolkit app, String name, Object obj) {
        return new AddRepositoryCommand(app, name, obj);
    }

    public static Command makeFTPCommand(SRAToolkit app, Object obj) {
        return new FTPCommand(app, obj);
    }

    public static Command makeSerialCommandPair(Command first, Command second) {
        return new SerialCommandPair(first, second);
    }

    protected abstract boolean execute() throws Exception;

    protected Command() {
        this(null, null);
    }

    protected Command(SRAToolkit _app, Object _obj) {
        this.app = _app;
        this.obj = _obj;
        this.number = ++s_number;
    }

    protected String myNumber() {
        return "#" + this.number + ") ";
    }
}

