/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.kfs;

import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;

public class KGapConfig {
    String[] lines;
    String[] fields;
    int lineno;

    public boolean advanceNextLine() {
        if (++this.lineno >= this.lines.length) {
            return false;
        }
        String line = this.lines[this.lineno];
        if (this.lineno == 0 && line.startsWith("version ")) {
            String version = line.substring(8);
            if (version.equals("1.0")) {
                return this.advanceNextLine();
            }
            return false;
        }
        this.fields = line.split("[|]");
        return true;
    }

    public String getProjectId() {
        return "dbGaP-" + this.fields[0];
    }

    public String getEncryptionKey() {
        return this.fields[1];
    }

    public String getDownloadTicket() {
        return this.fields[2];
    }

    public String getDescription() {
        return this.fields[3];
    }

    public static KGapConfig make(String path) throws VDBException {
        String text = KGapConfig.DecodeFile(path);
        if (text == null) {
            throw new VDBException("error decoding NCBI Gap Config file");
        }
        String[] lines = text.split("\r?\n");
        return new KGapConfig(lines);
    }

    private KGapConfig(String[] _lines) {
        this.lines = _lines;
        this.fields = null;
        this.lineno = -1;
    }

    private static native String DecodeFile(String var0);

    public static void main(String[] args) {
        try {
            System.loadLibrary("vdb_jni");
            KGapConfig kgc = KGapConfig.make(args[0]);
            int i = 1;
            while (kgc.advanceNextLine()) {
                SRAToolkit.debugPrintln("main: advanced to line " + i);
                SRAToolkit.debugPrintln("main: project-id = '" + kgc.getProjectId() + "', encryption-key = '" + kgc.getEncryptionKey() + "', download-ticket = '" + kgc.getDownloadTicket() + "', description = '" + kgc.getDescription() + "'");
                ++i;
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }
}

