/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.kfg;

import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.klib.KRef;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import java.io.File;

public class KConfig
implements KRef {
    private long self;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws VDBException {
        long obj = 0L;
        KConfig kConfig = this;
        synchronized (kConfig) {
            obj = this.self;
            this.self = 0L;
        }
        if (obj != 0L) {
            this.Release(obj);
        }
    }

    @Override
    public KRef duplicate() throws VDBException {
        if (this.self == 0L) {
            throw new VDBException("failed to duplicate KConfig - null reference");
        }
        long dup = this.Duplicate(this.self);
        return new KConfig(dup);
    }

    public static KConfig make() throws VDBException {
        long obj = KConfig.Make(null);
        if (obj == 0L) {
            throw new VDBException();
        }
        return new KConfig(obj);
    }

    public static KConfig make(String search_base) throws VDBException {
        long obj = KConfig.Make(search_base);
        if (obj == 0L) {
            throw new VDBException("failed to create KConfig ( with search base '" + search_base + "' )");
        }
        return new KConfig(obj);
    }

    public KConfigNode openNodeRead(String path) throws VDBException {
        long obj = this.OpenNodeRead(this.self, path);
        if (obj == 0L) {
            throw new VDBException("node '" + path + "' not found or not readable");
        }
        return new KConfigNodeImpl(obj);
    }

    public KConfigNode openNodeUpdate(String path) throws VDBException {
        long obj = this.OpenNodeUpdate(this.self, path);
        if (obj == 0L) {
            throw new VDBException("node '" + path + "' cannot be opened for update");
        }
        return new KConfigNodeImpl(obj);
    }

    public void commit() throws VDBException {
        if (!this.Commit(this.self)) {
            throw new VDBException("failed to commit KConfig");
        }
    }

    public String readString(String path) throws VDBException {
        String str = this.ReadString(this.self, path);
        if (str == null) {
            throw new VDBException("failed to read node '" + path + "' as String");
        }
        return str;
    }

    public static void disableUserSettings() {
        KConfig.DisableUserSettings();
    }

    private KConfig(long obj) {
        this.self = obj;
    }

    public static void main(String[] args) {
        SRAToolkit.setDebug();
        System.loadLibrary("vdb_jni");
        try {
            KConfig kfg = KConfig.make();
            SRAToolkit.debugPrintln("successfully created KConfig");
            KConfigNode node = kfg.openNodeRead(null);
            SRAToolkit.debugPrintln("successfully opened root node for read");
            node.release();
            node = kfg.openNodeUpdate("ok");
            SRAToolkit.debugPrintln("succesfully opened 'ok' node for update");
            node.write("something nice");
            SRAToolkit.debugPrintln("succesfully updated 'ok' node");
            node.release();
            kfg.commit();
            SRAToolkit.debugPrintln("succesfully committed KConfig");
            String name = "repository/user/main/public/root";
            SRAToolkit.debugPrintln("\nopenNodeRead(" + name + ")...");
            try {
                node = kfg.openNodeRead(name);
                SRAToolkit.debugPrintln("...opened " + name);
                SRAToolkit.debugPrintln(name + "=" + node.read());
                node.release();
            }
            catch (VDBException e) {
                SRAToolkit.debugPrintln("expected: " + e);
                SRAToolkit.debugPrintln("openNodeUpdate(" + name + ")...");
                node = kfg.openNodeUpdate(name);
                SRAToolkit.debugPrintln("...opened " + name);
                node.write(System.getProperty("user.home") + File.separator + "ncbi" + File.separator + "public");
                SRAToolkit.debugPrintln(name + "=" + node.read());
                node.release();
                kfg.commit();
            }
            kfg.release();
            KConfig.disableUserSettings();
            kfg = KConfig.make();
            SRAToolkit.debugPrintln("openNodeRead(" + name + ")...");
            try {
                node = kfg.openNodeRead(name);
                SRAToolkit.debugPrintln("...opened " + name);
                SRAToolkit.debugPrintln(name + "=" + node.read());
                node.release();
            }
            catch (VDBException e) {
                SRAToolkit.debugPrintln("expected: " + e);
            }
            kfg.release();
        }
        catch (Exception x) {
            SRAToolkit.debugPrintln("failed to create KConfig");
        }
    }

    public long getSelf() {
        return this.self;
    }

    protected native long Duplicate(long var1) throws VDBException;

    protected native boolean Release(long var1) throws VDBException;

    private static native long Make(String var0) throws VDBException;

    private native long OpenNodeRead(long var1, String var3) throws VDBException;

    private native long OpenNodeUpdate(long var1, String var3) throws VDBException;

    private native boolean Commit(long var1) throws VDBException;

    private native String ReadString(long var1, String var3) throws VDBException;

    private static native void DisableUserSettings();

    class KConfigNodeImpl
    implements KConfigNode {
        private long self;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws VDBException {
            long obj = 0L;
            KConfigNodeImpl kConfigNodeImpl = this;
            synchronized (kConfigNodeImpl) {
                obj = this.self;
                this.self = 0L;
            }
            if (obj != 0L) {
                this.Release(obj);
            }
        }

        @Override
        public KRef duplicate() throws VDBException {
            if (this.self == 0L) {
                throw new VDBException("failed to duplicate KConfigNode - null reference");
            }
            long dup = this.Duplicate(this.self);
            return new KConfigNodeImpl(dup);
        }

        @Override
        public String[] listChildren() {
            return this.ListChildren(this.self);
        }

        @Override
        public String read() {
            return this.Read(this.self);
        }

        @Override
        public void write(String val) throws VDBException {
            if (!this.Write(this.self, val)) {
                throw new VDBException("failed to write to KConfigNode");
            }
        }

        @Override
        public void append(String val) throws VDBException {
            if (!this.Append(this.self, val)) {
                throw new VDBException("failed to append to KConfigNode");
            }
        }

        @Override
        public String readAttr(String name) {
            return this.ReadAttr(this.self, name);
        }

        @Override
        public void writeAttr(String name, String value) throws VDBException {
            if (!this.WriteAttr(this.self, name, value)) {
                throw new VDBException("failed to write KConfigNode attribute");
            }
        }

        @Override
        public KConfigNode openNodeRead(String path) throws VDBException {
            long obj = this.OpenNodeRead(this.self, path);
            if (obj == 0L) {
                throw new VDBException("node '" + path + "' not found or not readable");
            }
            return new KConfigNodeImpl(obj);
        }

        @Override
        public KConfigNode openNodeUpdate(String path) throws VDBException {
            long obj = this.OpenNodeUpdate(this.self, path);
            if (obj == 0L) {
                throw new VDBException("node '" + path + "' cannot be opened for update");
            }
            return new KConfigNodeImpl(obj);
        }

        @Override
        public void dropAll() throws VDBException {
            if (!this.DropAll(this.self)) {
                throw new VDBException("failed to drop KConfigNode children");
            }
        }

        @Override
        public void dropAttr(String attr) throws VDBException {
            if (!this.DropAttr(this.self, attr)) {
                throw new VDBException("failed to drop KConfigNode attributes");
            }
        }

        @Override
        public void dropChild(String path) throws VDBException {
            if (!this.DropChild(this.self, path)) {
                throw new VDBException("failed to drop KConfigNode child '" + path + "'");
            }
        }

        @Override
        public void renameAttr(String from, String to) throws VDBException {
            if (!this.RenameAttr(this.self, from, to)) {
                throw new VDBException("failed to rename KConfigNode attribute from '" + from + "' to '" + to + "'");
            }
        }

        @Override
        public void renameChild(String from, String to) throws VDBException {
            if (!this.RenameChild(this.self, from, to)) {
                throw new VDBException("failed to rename KConfigNode child from '" + from + "' to '" + to + "'");
            }
        }

        @Override
        public String readString() throws VDBException {
            String str = this.ReadString(this.self);
            if (str == null) {
                throw new VDBException("failed to read KConfigNode as String");
            }
            return str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readString(String childPath) throws VDBException {
            KConfigNode child = this.openNodeRead(childPath);
            try {
                String string = child.readString();
                return string;
            }
            finally {
                child.release();
            }
        }

        KConfigNodeImpl(long self_node) {
            this.self = self_node;
        }

        protected native long Duplicate(long var1) throws VDBException;

        protected native boolean Release(long var1) throws VDBException;

        private native String[] ListChildren(long var1);

        private native String Read(long var1);

        private native boolean Write(long var1, String var3) throws VDBException;

        private native boolean Append(long var1, String var3) throws VDBException;

        private native String ReadAttr(long var1, String var3);

        private native boolean WriteAttr(long var1, String var3, String var4) throws VDBException;

        private native long OpenNodeRead(long var1, String var3) throws VDBException;

        private native long OpenNodeUpdate(long var1, String var3) throws VDBException;

        private native boolean DropAll(long var1) throws VDBException;

        private native boolean DropAttr(long var1, String var3) throws VDBException;

        private native boolean DropChild(long var1, String var3) throws VDBException;

        private native boolean RenameAttr(long var1, String var3, String var4) throws VDBException;

        private native boolean RenameChild(long var1, String var3, String var4) throws VDBException;

        private native String ReadString(long var1) throws VDBException;
    }
}

