/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import htsjdk.samtools.util.IntervalList;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import picard.vcf.processor.VariantAccumulatorExecutor;
import picard.vcf.processor.VariantIteratorProducer;

public class VariantProcessor<RESULT, ACCUMULATOR extends Accumulator<RESULT>> {
    final ResultMerger<RESULT> merger;
    final VariantAccumulatorExecutor<ACCUMULATOR, RESULT> executor;

    VariantProcessor(ResultMerger<RESULT> merger, VariantAccumulatorExecutor<ACCUMULATOR, RESULT> executor) {
        this.merger = merger;
        this.executor = executor;
    }

    public RESULT process() {
        this.executor.start();
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ArrayList results = new ArrayList();
        for (Accumulator a : this.executor.accumulators()) {
            results.add(a.result());
        }
        return this.merger.merge(results);
    }

    public static class Builder<A extends Accumulator<R>, R> {
        final AccumulatorGenerator<A, R> accumulatorGenerator;
        ResultMerger<R> reducer = null;
        IntervalList intervals = null;
        final List<File> inputs = new ArrayList<File>();
        int threadCount = 1;

        Builder(AccumulatorGenerator<A, R> accumulatorGenerator) {
            this.accumulatorGenerator = accumulatorGenerator;
        }

        public Builder<A, R> multithreadingBy(int threadCount) {
            if (threadCount < 1) {
                throw new IllegalArgumentException("Multithreading value must exceed 0.");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder<A, R> withInput(File ... vcfs) {
            Collections.addAll(this.inputs, vcfs);
            return this;
        }

        public Builder<A, R> limitingProcessedRegionsTo(IntervalList intervals) {
            if (this.intervals != null) {
                throw new IllegalStateException("Already provided an interval list.");
            }
            this.intervals = IntervalList.copyOf(intervals);
            return this;
        }

        public Builder<A, R> combiningResultsBy(ResultMerger<R> reducer) {
            if (this.reducer != null) {
                throw new IllegalStateException("Already provided a reducer.");
            }
            this.reducer = reducer;
            return this;
        }

        public static <A extends Accumulator<R>, R> Builder<A, R> generatingAccumulatorsBy(AccumulatorGenerator<A, R> generator) {
            return new Builder<A, R>(generator);
        }

        public VariantProcessor<R, A> build() {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("You need to provided some inputs before building.");
            }
            if (this.reducer == null) {
                throw new IllegalStateException("You must provide a reducer before building.");
            }
            return new VariantProcessor<R, A>(this.reducer, new VariantAccumulatorExecutor.MultiThreadedChunkBased<A, R>(this.threadCount, this.composeVcfIteratorProducerFromBuilderArguments(), this.accumulatorGenerator));
        }

        private VariantIteratorProducer composeVcfIteratorProducerFromBuilderArguments() {
            VariantIteratorProducer ret = this.intervals == null ? VariantIteratorProducer.byHundredMegabaseChunks(this.inputs) : VariantIteratorProducer.byHundredMegabaseChunksWithOnTheFlyFilteringByInterval(this.inputs, this.intervals);
            return ret;
        }
    }

    public static interface ResultMerger<RESULT> {
        public RESULT merge(Collection<RESULT> var1);
    }

    public static interface AccumulatorGenerator<ACCUMULATOR extends Accumulator<RESULT>, RESULT> {
        public ACCUMULATOR build();
    }

    public static interface Accumulator<RESULT> {
        public void accumulate(VariantContext var1);

        public RESULT result();
    }
}

