/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.sam.util.ReadNameParsingUtils;

public class PhysicalLocation {
    public static final String DEFAULT_READ_NAME_REGEX = "[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*";
    private final String readNameRegex;
    private Pattern readNamePattern;
    private short tile = (short)-1;
    private int x = -1;
    private int y = -1;
    private final int[] tmpLocationFields = new int[10];

    public PhysicalLocation() {
        this(DEFAULT_READ_NAME_REGEX);
    }

    public PhysicalLocation(String readNameRegExp) {
        this.readNameRegex = readNameRegExp;
    }

    public short getTile() {
        return this.tile;
    }

    public void setTile(short tile) {
        this.tile = tile;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean addLocationInformation(String readName, PhysicalLocation loc) {
        Matcher m;
        if (this.readNameRegex == DEFAULT_READ_NAME_REGEX) {
            int fields = ReadNameParsingUtils.getRapidDefaultReadNameRegexSplit(readName, ':', this.tmpLocationFields);
            if (fields != 5 && fields != 7) {
                throw new PicardException(String.format(" READ_NAME_REGEX '%s' did not match read name '%s'.  ", this.readNameRegex, readName));
            }
            int offset = fields == 7 ? 2 : 0;
            loc.setTile((short)this.tmpLocationFields[offset + 2]);
            loc.setX(this.tmpLocationFields[offset + 3]);
            loc.setY(this.tmpLocationFields[offset + 4]);
            return true;
        }
        if (this.readNameRegex == null) {
            return false;
        }
        if (this.readNamePattern == null) {
            this.readNamePattern = Pattern.compile(this.readNameRegex);
        }
        if ((m = this.readNamePattern.matcher(readName)).matches()) {
            loc.setTile((short)Integer.parseInt(m.group(1)));
            loc.setX(Integer.parseInt(m.group(2)));
            loc.setY(Integer.parseInt(m.group(3)));
            return true;
        }
        throw new PicardException(String.format("READ_NAME_REGEX '%s' did not match read name '%s'. ", this.readNameRegex, readName));
    }
}

