/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.MergingIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Merges multiple VCF or BCF files into one VCF file. Input files must be sorted by their contigs and, within contigs, by start position. The input files must have the same sample and contig lists. An index file is created and a sequence dictionary is required by default.", usageShort="Merges multiple VCF or BCF files into one VCF file or BCF", programGroup=VcfOrBcf.class)
public class MergeVcfs
extends CommandLineProgram {
    @Option(shortName="I", doc="VCF or BCF input files File format is determined by file extension.", minElements=1)
    public List<File> INPUT;
    @Option(shortName="O", doc="The merged VCF or BCF file. File format is determined by file extension.")
    public File OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionary in the input file", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(MergeVcfs.class);

    public static void main(String[] argv) {
        new MergeVcfs().instanceMainWithExit(argv);
    }

    public MergeVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progress = new ProgressLogger(this.log, 10000);
        ArrayList sampleList = new ArrayList();
        ArrayList<CloseableIterator> iteratorCollection = new ArrayList<CloseableIterator>(this.INPUT.size());
        HashSet<VCFHeader> headers = new HashSet<VCFHeader>(this.INPUT.size());
        VariantContextComparator variantContextComparator = null;
        SAMSequenceDictionary sequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            sequenceDictionary = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.SEQUENCE_DICTIONARY).getFileHeader().getSequenceDictionary();
        }
        for (File file : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file);
            VCFFileReader fileReader = new VCFFileReader(file, false);
            VCFHeader fileHeader = fileReader.getFileHeader();
            if (variantContextComparator == null) {
                variantContextComparator = fileHeader.getVCFRecordComparator();
            } else if (!variantContextComparator.isCompatible((Collection)fileHeader.getContigLines())) {
                throw new IllegalArgumentException("The contig entries in input file " + file.getAbsolutePath() + " are not compatible with the others.");
            }
            if (sequenceDictionary == null) {
                sequenceDictionary = fileHeader.getSequenceDictionary();
            }
            if (sampleList.isEmpty()) {
                sampleList.addAll(fileHeader.getSampleNamesInOrder());
            } else if (!((Object)sampleList).equals(fileHeader.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + file.getAbsolutePath() + " has sample entries that don't match the other files.");
            }
            headers.add(fileHeader);
            iteratorCollection.add(fileReader.iterator());
        }
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sequenceDictionary).clearOptions();
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter writer = builder.build();
        writer.writeHeader(new VCFHeader(VCFUtils.smartMergeHeaders(headers, (boolean)false), sampleList));
        MergingIterator mergingIterator = new MergingIterator((Comparator)variantContextComparator, iteratorCollection);
        while (mergingIterator.hasNext()) {
            VariantContext context = (VariantContext)mergingIterator.next();
            writer.add(context);
            progress.record(context.getChr(), context.getStart());
        }
        CloserUtil.close((Object)mergingIterator);
        writer.close();
        return 0;
    }
}

