/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CallingMetricAccumulator;
import picard.vcf.processor.VariantProcessor;

@CommandLineProgramProperties(usage="Collects per-sample and aggregate (spanning all samples) metrics from the provided VCF file.", usageShort="Collects per-sample and aggregate (spanning all samples) metrics from the provided VCF file", programGroup=Metrics.class)
public class CollectVariantCallingMetrics
extends CommandLineProgram {
    @Option(shortName="I", doc="Input vcf file for analysis")
    public File INPUT;
    @Option(shortName="O", doc="Path (except for the file extension) of output metrics files to write.")
    public File OUTPUT;
    @Option(doc="Reference dbSNP file in dbSNP or VCF format.")
    public File DBSNP;
    @Option(shortName="TI", doc="Target intervals to restrict analysis to.", optional=true)
    public File TARGET_INTERVALS;
    @Option(shortName="SD", optional=true, doc="If present, speeds loading of dbSNP file")
    public File SEQUENCE_DICTIONARY = null;
    @Option(doc="Deprecated option will be removed in a future release.")
    public Boolean REQUIRE_INDEX = false;
    @Option
    public int THREAD_COUNT = 1;
    private final Log log = Log.getInstance(CollectVariantCallingMetrics.class);

    public static void main(String[] args) {
        new CollectVariantCallingMetrics().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        boolean requiresIndex = this.TARGET_INTERVALS != null || this.THREAD_COUNT > 1;
        VCFFileReader variantReader = new VCFFileReader(this.INPUT, requiresIndex);
        SAMSequenceDictionary sequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SAMFileReader.getSequenceDictionary((File)this.SEQUENCE_DICTIONARY) : variantReader.getFileHeader().getSequenceDictionary();
        CloserUtil.close((Object)variantReader);
        this.log.info(new Object[]{"Loading dbSNP file ..."});
        final DbSnpBitSetUtil.DbSnpBitSets dbsnp = DbSnpBitSetUtil.createSnpAndIndelBitSets(this.DBSNP, sequenceDictionary);
        this.log.info(new Object[]{"Starting iteration of variants."});
        VariantProcessor.Builder<CallingMetricAccumulator, CallingMetricAccumulator.Result> builder = VariantProcessor.Builder.generatingAccumulatorsBy(new VariantProcessor.AccumulatorGenerator<CallingMetricAccumulator, CallingMetricAccumulator.Result>(){

            @Override
            public CallingMetricAccumulator build() {
                return new CallingMetricAccumulator(dbsnp);
            }
        }).combiningResultsBy(new VariantProcessor.ResultMerger<CallingMetricAccumulator.Result>(){

            @Override
            public CallingMetricAccumulator.Result merge(Collection<CallingMetricAccumulator.Result> resultsToReduce) {
                return CallingMetricAccumulator.Result.merge(resultsToReduce);
            }
        }).withInput(this.INPUT).multithreadingBy(this.THREAD_COUNT);
        if (this.TARGET_INTERVALS != null) {
            builder.limitingProcessedRegionsTo(IntervalList.fromFile((File)this.TARGET_INTERVALS).uniqued());
        }
        CallingMetricAccumulator.Result result = builder.build().process();
        MetricsFile detail = this.getMetricsFile();
        MetricsFile summary = this.getMetricsFile();
        summary.addMetric((MetricBase)result.summary);
        for (VariantCallingDetailMetrics detailMetric : result.details) {
            detail.addMetric((MetricBase)detailMetric);
        }
        String outputPrefix = this.OUTPUT.getAbsolutePath() + ".";
        detail.write(new File(outputPrefix + VariantCallingDetailMetrics.getFileExtension()));
        summary.write(new File(outputPrefix + VariantCallingSummaryMetrics.getFileExtension()));
        return 0;
    }

    public static class VariantCallingDetailMetrics
    extends VariantCallingSummaryMetrics {
        public String SAMPLE_ALIAS;
        public double HET_HOMVAR_RATIO;
        long numHets;
        long numHomVar;

        public static String getFileExtension() {
            return "variant_calling_detail_metrics";
        }

        public static void foldInto(VariantCallingDetailMetrics target, Collection<VariantCallingDetailMetrics> metrics) {
            VariantCallingSummaryMetrics.foldInto(target, metrics);
            HashSet<String> sampleAliases = new HashSet<String>();
            for (VariantCallingDetailMetrics metric : metrics) {
                target.numHets += metric.numHets;
                target.numHomVar += metric.numHomVar;
                sampleAliases.add(metric.SAMPLE_ALIAS);
            }
            target.updateDerivedValuesInPlace();
            if (sampleAliases.size() != 1) {
                throw new IllegalArgumentException("Provided metrics do not have the same sample name.");
            }
            target.SAMPLE_ALIAS = (String)sampleAliases.iterator().next();
        }

        @Override
        public void updateDerivedValuesInPlace() {
            super.updateDerivedValuesInPlace();
            this.HET_HOMVAR_RATIO = (double)this.numHets / (double)this.numHomVar;
        }
    }

    public static class VariantCallingSummaryMetrics
    extends MetricBase {
        public long TOTAL_SNPS;
        public long NUM_IN_DB_SNP;
        public long NOVEL_SNPS;
        public long FILTERED_SNPS;
        public float PCT_DBSNP;
        public double DBSNP_TITV;
        public double NOVEL_TITV;
        public long TOTAL_INDELS;
        public long NOVEL_INDELS;
        public long FILTERED_INDELS;
        public float PCT_DBSNP_INDELS;
        public long NUM_IN_DB_SNP_INDELS;
        public double DBSNP_INS_DEL_RATIO;
        public double NOVEL_INS_DEL_RATIO;
        public double TOTAL_MULTIALLELIC_SNPS;
        public double NUM_IN_DB_SNP_MULTIALLELIC;
        public double TOTAL_COMPLEX_INDELS;
        public double NUM_IN_DB_SNP_COMPLEX_INDELS;
        public double SNP_REFERENCE_BIAS;
        public long NUM_SINGLETONS;
        long refAlleleObs;
        long altAlleleObs;
        long novelDeletions;
        long novelInsertions;
        long novelTransitions;
        long novelTransversions;
        long dbSnpDeletions;
        long dbSnpInsertions;
        long dbSnpTransitions;
        long dbSnpTransversions;

        public static String getFileExtension() {
            return "variant_calling_summary_metrics";
        }

        public void updateDerivedValuesInPlace() {
            this.PCT_DBSNP = (float)this.NUM_IN_DB_SNP / (float)this.TOTAL_SNPS;
            this.NOVEL_SNPS = this.TOTAL_SNPS - this.NUM_IN_DB_SNP;
            this.SNP_REFERENCE_BIAS = (double)this.refAlleleObs / (double)(this.refAlleleObs + this.altAlleleObs);
            if (this.dbSnpTransversions > 0L) {
                this.DBSNP_TITV = (double)this.dbSnpTransitions / (double)this.dbSnpTransversions;
            }
            if (this.novelTransversions > 0L) {
                this.NOVEL_TITV = (double)this.novelTransitions / (double)this.novelTransversions;
            }
            this.PCT_DBSNP_INDELS = (float)this.NUM_IN_DB_SNP_INDELS / (float)this.TOTAL_INDELS;
            this.NOVEL_INDELS = this.TOTAL_INDELS - this.NUM_IN_DB_SNP_INDELS;
            if (this.dbSnpDeletions > 0L) {
                this.DBSNP_INS_DEL_RATIO = (double)this.dbSnpInsertions / (double)this.dbSnpDeletions;
            }
            if (this.novelDeletions > 0L) {
                this.NOVEL_INS_DEL_RATIO = (double)this.novelInsertions / (double)this.novelDeletions;
            }
        }

        public static <T extends VariantCallingSummaryMetrics> void foldInto(T target, Collection<T> metrics) {
            for (VariantCallingSummaryMetrics metric : metrics) {
                target.TOTAL_SNPS += metric.TOTAL_SNPS;
                target.NUM_IN_DB_SNP += metric.NUM_IN_DB_SNP;
                target.FILTERED_SNPS += metric.FILTERED_SNPS;
                target.TOTAL_INDELS += metric.TOTAL_INDELS;
                target.FILTERED_INDELS += metric.FILTERED_INDELS;
                target.NUM_IN_DB_SNP_INDELS += metric.NUM_IN_DB_SNP_INDELS;
                target.TOTAL_MULTIALLELIC_SNPS += metric.TOTAL_MULTIALLELIC_SNPS;
                target.NUM_IN_DB_SNP_MULTIALLELIC += metric.NUM_IN_DB_SNP_MULTIALLELIC;
                target.TOTAL_COMPLEX_INDELS += metric.TOTAL_COMPLEX_INDELS;
                target.NUM_IN_DB_SNP_COMPLEX_INDELS += metric.NUM_IN_DB_SNP_COMPLEX_INDELS;
                target.NUM_SINGLETONS += metric.NUM_SINGLETONS;
                target.refAlleleObs += metric.refAlleleObs;
                target.altAlleleObs += metric.altAlleleObs;
                target.novelDeletions += metric.novelDeletions;
                target.novelInsertions += metric.novelInsertions;
                target.novelTransitions += metric.novelTransitions;
                target.novelTransversions += metric.novelTransversions;
                target.dbSnpDeletions += metric.dbSnpDeletions;
                target.dbSnpInsertions += metric.dbSnpInsertions;
                target.dbSnpTransitions += metric.dbSnpTransitions;
                target.dbSnpTransversions += metric.dbSnpTransversions;
            }
            target.updateDerivedValuesInPlace();
        }
    }
}

